"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooltipTableBody = void 0;
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var tooltip_table_cell_1 = require("./tooltip_table_cell");
var tooltip_table_color_cell_1 = require("./tooltip_table_color_cell");
var tooltip_table_row_1 = require("./tooltip_table_row");
var TooltipTableBody = function (_a) {
    var className = _a.className, props = __rest(_a, ["className"]);
    var classes = (0, classnames_1.default)('echTooltip__tableBody', className);
    if ('children' in props) {
        return react_1.default.createElement("tbody", { className: classes }, props.children);
    }
    return (react_1.default.createElement("tbody", { className: classes }, props.items.map(function (item, i) {
        var isHighlighted = item.isHighlighted, isVisible = item.isVisible;
        if (!isVisible)
            return null;
        return (react_1.default.createElement(tooltip_table_row_1.TooltipTableRow, { key: i, isHighlighted: isHighlighted }, props.columns.map(function (column, j) {
            var _a;
            return renderCellContent(item, column, (_a = column.id) !== null && _a !== void 0 ? _a : "".concat(column.type, "-").concat(j));
        })));
    })));
};
exports.TooltipTableBody = TooltipTableBody;
function getCellStyles(_a) {
    var style = _a.style, type = _a.type;
    var textAlign = type === 'number' ? 'left' : type === 'text' ? 'right' : undefined;
    return __assign({ textAlign: textAlign }, style);
}
function renderCellContent(item, column, key) {
    if (column.type === 'color') {
        return react_1.default.createElement(tooltip_table_color_cell_1.TooltipTableColorCell, { color: item.color, key: key });
    }
    return (react_1.default.createElement(tooltip_table_cell_1.TooltipTableCell, { style: getCellStyles(column), key: key }, column.cell(item)));
}
//# sourceMappingURL=tooltip_table_body.js.map