"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiScreenReaderOnly = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _clone_element = require("../../../services/theme/clone_element");

var _screen_reader_only = require("./screen_reader_only.styles");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiScreenReaderOnly = function EuiScreenReaderOnly(_ref) {
  var children = _ref.children,
      className = _ref.className,
      showOnFocus = _ref.showOnFocus;
  var classes = (0, _classnames.default)(className, children.props.className);
  var styles = (0, _screen_reader_only.euiScreenReaderOnlyStyles)(showOnFocus);
  var cssStyles = [styles.euiScreenReaderOnly];
  var props = {
    className: classes.length ? classes : undefined,
    css: cssStyles
  };
  return (0, _clone_element.cloneElementWithCss)(children, props);
};

exports.EuiScreenReaderOnly = EuiScreenReaderOnly;
EuiScreenReaderOnly.propTypes = {
  /**
     * ReactElement to render as this component's content
     */
  children: _propTypes.default.element.isRequired,

  /**
     * For keyboard navigation, force content to display visually upon focus.
     */
  showOnFocus: _propTypes.default.bool,
  className: _propTypes.default.string
};