"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAspectRatio = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _excluded = ["children", "className", "height", "width", "maxWidth", "style"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiAspectRatio = function EuiAspectRatio(_ref) {
  var children = _ref.children,
      className = _ref.className,
      height = _ref.height,
      width = _ref.width,
      maxWidth = _ref.maxWidth,
      style = _ref.style,
      rest = _objectWithoutProperties(_ref, _excluded);

  var classes = (0, _classnames.default)('euiAspectRatio', className);

  var euiAspectRatioStyle = _objectSpread({
    aspectRatio: "".concat(width, " / ").concat(height),
    height: 'auto',
    width: '100%',
    maxWidth: maxWidth
  }, style);

  var props = _objectSpread({
    className: classes,
    style: euiAspectRatioStyle
  }, rest);

  return /*#__PURE__*/_react.default.cloneElement(children, props);
};

exports.EuiAspectRatio = EuiAspectRatio;
EuiAspectRatio.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
       * Aspect ratio height. For example 9 would be widescreen video.
       */
  height: _propTypes.default.number.isRequired,

  /**
       * Aspect ratio width. For example 16 would be widescreen video.
       */
  width: _propTypes.default.number.isRequired,

  /**
       * The maximum width you want the child to stretch to.
       */
  maxWidth: _propTypes.default.any,
  children: _propTypes.default.element.isRequired
};