"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponsiveMax = exports.limitBreadcrumbs = exports.EuiBreadcrumbs = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../i18n");

var _services = require("../../services");

var _breadcrumb = require("./breadcrumb");

var _breadcrumbs = require("./breadcrumbs.styles");

var _react2 = require("@emotion/react");

var _excluded = ["breadcrumbs", "className", "responsive", "truncate", "max", "type", "lastBreadcrumbIsCurrentPage"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var responsiveDefault = {
  xs: 1,
  s: 2,
  m: 4
};

var EuiBreadcrumbs = function EuiBreadcrumbs(_ref) {
  var breadcrumbs = _ref.breadcrumbs,
      className = _ref.className,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? responsiveDefault : _ref$responsive,
      _ref$truncate = _ref.truncate,
      truncate = _ref$truncate === void 0 ? true : _ref$truncate,
      _ref$max = _ref.max,
      max = _ref$max === void 0 ? 5 : _ref$max,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'page' : _ref$type,
      _ref$lastBreadcrumbIs = _ref.lastBreadcrumbIsCurrentPage,
      lastBreadcrumbIsCurrentPage = _ref$lastBreadcrumbIs === void 0 ? true : _ref$lastBreadcrumbIs,
      rest = _objectWithoutProperties(_ref, _excluded);

  var ariaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumbs.nav.ariaLabel', 'Breadcrumbs');
  var euiTheme = (0, _services.useEuiTheme)();
  var breadcrumbsListStyles = (0, _breadcrumbs.euiBreadcrumbsListStyles)(euiTheme);
  var cssBreadcrumbsListStyles = [breadcrumbsListStyles.euiBreadcrumbs__list, truncate && breadcrumbsListStyles.isTruncated];
  var responsiveMax = useResponsiveMax(responsive, max);
  var visibleBreadcrumbs = (0, _react.useMemo)(function () {
    var shouldCollapseBreadcrumbs = responsiveMax && breadcrumbs.length > responsiveMax;
    return shouldCollapseBreadcrumbs ? limitBreadcrumbs(breadcrumbs, responsiveMax) : breadcrumbs;
  }, [breadcrumbs, responsiveMax]);
  var breadcrumbChildren = (0, _react.useMemo)(function () {
    return visibleBreadcrumbs.map(function (breadcrumb, index) {
      var isFirstBreadcrumb = index === 0;
      var isLastBreadcrumb = index === visibleBreadcrumbs.length - 1;
      var isOnlyBreadcrumb = visibleBreadcrumbs.length === 1;
      var sharedProps = {
        type: type,
        truncate: truncate
      };
      return breadcrumb.isCollapsedButton ? (0, _react2.jsx)(_breadcrumb.EuiBreadcrumbCollapsed, _extends({
        key: "collapsed"
      }, sharedProps, {
        isFirstBreadcrumb: isFirstBreadcrumb
      }), (0, _react2.jsx)(EuiBreadcrumbs, {
        breadcrumbs: breadcrumb.overflowBreadcrumbs,
        lastBreadcrumbIsCurrentPage: false,
        responsive: false,
        truncate: false,
        max: 0
      })) : (0, _react2.jsx)(_breadcrumb.EuiBreadcrumb, _extends({
        key: index
      }, sharedProps), (0, _react2.jsx)(_breadcrumb.EuiBreadcrumbContent, _extends({
        isFirstBreadcrumb: isFirstBreadcrumb,
        isLastBreadcrumb: isLastBreadcrumb,
        isOnlyBreadcrumb: isOnlyBreadcrumb,
        highlightLastBreadcrumb: isLastBreadcrumb && lastBreadcrumbIsCurrentPage
      }, sharedProps, breadcrumb)));
    });
  }, [visibleBreadcrumbs, truncate, type, lastBreadcrumbIsCurrentPage]);
  return (0, _react2.jsx)("nav", _extends({
    "aria-label": ariaLabel,
    className: (0, _classnames.default)('euiBreadcrumbs', className)
  }, rest), (0, _react2.jsx)("ol", {
    className: "euiBreadcrumbs__list",
    css: cssBreadcrumbsListStyles
  }, breadcrumbChildren));
};

exports.EuiBreadcrumbs = EuiBreadcrumbs;
EuiBreadcrumbs.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
     * Hides extra (above the max) breadcrumbs under a collapsed item as the window gets smaller.
     * Pass a custom #EuiBreadcrumbResponsiveMaxCount object to change the number of breadcrumbs to show at the particular breakpoints.
     *
     * Pass `false` to turn this behavior off.
     *
     * Default: `{ xs: 1, s: 2, m: 4 }`
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.any.isRequired]),

  /**
     * Forces all breadcrumbs to single line and
     * truncates each breadcrumb to a particular width,
     * except for the last item
     */
  truncate: _propTypes.default.bool,

  /**
     * Collapses the inner items past the maximum set here
     * into a single ellipses item.
     * Omitting or passing a `0` value will show all breadcrumbs.
     */
  max: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),

  /**
     * The array of individual #EuiBreadcrumb items
     */
  breadcrumbs: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    href: _propTypes.default.string,
    rel: _propTypes.default.string,
    onClick: _propTypes.default.func,

    /**
         * Visible label of the breadcrumb
         */
    text: _propTypes.default.node.isRequired,

    /**
         * Force a max-width on the breadcrumb text
         */
    truncate: _propTypes.default.bool,

    /**
         * Accepts any EuiLink `color` when rendered as one (has `href` or `onClick`)
         */
    color: _propTypes.default.any,

    /**
         * Override the existing `aria-current` which defaults to `page` for the last breadcrumb
         */
    "aria-current": _propTypes.default.any
  }).isRequired).isRequired,

  /**
     * Determines breadcrumbs appearance, with `page` being the default styling.
     * Application breadcrumbs should only be once per page, in (e.g.) EuiHeader
     */
  type: _propTypes.default.oneOf(["page", "application"]),

  /**
     * Whether the last breadcrumb should visually (and accessibly, to screen readers)
     * be highlighted as the current page. Defaults to true.
     */
  lastBreadcrumbIsCurrentPage: _propTypes.default.bool
};

var useResponsiveMax = function useResponsiveMax(responsive, max) {
  // Use the default object if they simply passed `true` for responsive
  var responsiveObject = _typeof(responsive) === 'object' ? responsive : responsiveDefault; // The max property collapses any breadcrumbs past the max quantity.
  // This is the same behavior we want for responsiveness.
  // So calculate the max value based on the combination of `max` and `responsive`

  var responsiveMax = max; // Set the calculated max to the number associated with the currentBreakpoint key if it exists

  var currentBreakpoint = (0, _services.useCurrentEuiBreakpoint)();

  if (responsive && currentBreakpoint && responsiveObject[currentBreakpoint]) {
    responsiveMax = responsiveObject[currentBreakpoint];
  } // Final check is to make sure max is used over a larger breakpoint value


  if (max && responsiveMax) {
    responsiveMax = max < responsiveMax ? max : responsiveMax;
  }

  return responsiveMax;
};

exports.useResponsiveMax = useResponsiveMax;

var limitBreadcrumbs = function limitBreadcrumbs(breadcrumbs, max) {
  var breadcrumbsAtStart = [];
  var breadcrumbsAtEnd = [];
  var limit = Math.min(max, breadcrumbs.length);
  var start = Math.floor(limit / 2);
  var overflowBreadcrumbs = breadcrumbs.slice(start, start + breadcrumbs.length - limit);

  for (var i = 0; i < limit; i++) {
    // We'll alternate with displaying breadcrumbs at the end and at the start, but be biased
    // towards breadcrumbs the end so that if max is an odd number, we'll have one more
    // breadcrumb visible at the end than at the beginning.
    var isEven = i % 2 === 0; // We're picking breadcrumbs from the front AND the back, so we treat each iteration as a
    // half-iteration.

    var normalizedIndex = Math.floor(i * 0.5);
    var indexOfBreadcrumb = isEven ? breadcrumbs.length - 1 - normalizedIndex : normalizedIndex;
    var breadcrumb = breadcrumbs[indexOfBreadcrumb];

    if (isEven) {
      breadcrumbsAtEnd.unshift(breadcrumb);
    } else {
      breadcrumbsAtStart.push(breadcrumb);
    }
  }

  return [].concat(breadcrumbsAtStart, [{
    isCollapsedButton: true,
    overflowBreadcrumbs: overflowBreadcrumbs
  }], breadcrumbsAtEnd);
};

exports.limitBreadcrumbs = limitBreadcrumbs;