"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeVisibleRows = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var computeVisibleRows = function computeVisibleRows(_ref) {
  var pagination = _ref.pagination,
      rowCount = _ref.rowCount;
  var startRow = pagination && pagination.pageSize > 0 ? pagination.pageIndex * pagination.pageSize : 0;
  var endRow = pagination && pagination.pageSize > 0 ? (pagination.pageIndex + 1) * pagination.pageSize : rowCount;
  endRow = Math.min(endRow, rowCount);
  var visibleRowCount = endRow - startRow;
  return {
    startRow: startRow,
    endRow: endRow,
    visibleRowCount: visibleRowCount
  };
};

exports.computeVisibleRows = computeVisibleRows;