"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRowHeightUtils = exports.useDefaultRowHeight = exports.cellPaddingsMap = exports.RowHeightUtils = exports.DEFAULT_ROW_HEIGHT = exports.AUTO_HEIGHT = void 0;

var _react = require("react");

var _services = require("../../../services");

var _predicate = require("../../../services/predicate");

var _sorting = require("./sorting");

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// TODO: Once JS variables are available, use them here instead of hard-coded maps
var cellPaddingsMap = {
  s: 4,
  m: 6,
  l: 8
};
exports.cellPaddingsMap = cellPaddingsMap;
var AUTO_HEIGHT = 'auto';
exports.AUTO_HEIGHT = AUTO_HEIGHT;
var DEFAULT_ROW_HEIGHT = 34;
exports.DEFAULT_ROW_HEIGHT = DEFAULT_ROW_HEIGHT;

var RowHeightUtils = /*#__PURE__*/function () {
  function RowHeightUtils(gridRef, outerGridElementRef, gridItemsRenderedRef, rerenderGridBodyRef) {
    var _this = this;

    _classCallCheck(this, RowHeightUtils);

    this.gridRef = gridRef;
    this.outerGridElementRef = outerGridElementRef;
    this.gridItemsRenderedRef = gridItemsRenderedRef;
    this.rerenderGridBodyRef = rerenderGridBodyRef;

    _defineProperty(this, "styles", {
      paddingTop: 0,
      paddingBottom: 0
    });

    _defineProperty(this, "getStylesForCell", function (rowHeightsOptions, rowIndex) {
      var height = _this.getRowHeightOption(rowIndex, rowHeightsOptions);

      if (height === AUTO_HEIGHT) {
        return {};
      }

      var lineCount = _this.getLineCount(height);

      if (lineCount) {
        return {
          WebkitLineClamp: lineCount,
          display: '-webkit-box',
          WebkitBoxOrient: 'vertical',
          height: '100%',
          overflow: 'hidden'
        };
      }

      return {
        height: '100%',
        overflow: 'hidden'
      };
    });

    _defineProperty(this, "heightsCache", new Map());

    _defineProperty(this, "timerId", void 0);

    _defineProperty(this, "lastUpdatedRow", Infinity);
  }

  _createClass(RowHeightUtils, [{
    key: "getRowHeightOption",
    value: function getRowHeightOption(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro, _rowHeightsOptions$ro2;

      return (_rowHeightsOptions$ro = rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : (_rowHeightsOptions$ro2 = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro2 === void 0 ? void 0 : _rowHeightsOptions$ro2[rowIndex]) !== null && _rowHeightsOptions$ro !== void 0 ? _rowHeightsOptions$ro : rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight;
    }
  }, {
    key: "isRowHeightOverride",
    value: function isRowHeightOverride(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro3;

      return (rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : (_rowHeightsOptions$ro3 = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro3 === void 0 ? void 0 : _rowHeightsOptions$ro3[rowIndex]) != null;
    }
  }, {
    key: "getCalculatedHeight",
    value: function getCalculatedHeight(heightOption, defaultHeight, rowIndex, isRowHeightOverride) {
      if ((0, _predicate.isObject)(heightOption) && heightOption.height) {
        return Math.max(heightOption.height, defaultHeight);
      }

      if (heightOption && (0, _predicate.isNumber)(heightOption)) {
        return Math.max(heightOption, defaultHeight);
      }

      if ((0, _predicate.isObject)(heightOption) && heightOption.lineCount) {
        if (isRowHeightOverride) {
          return this.getRowHeight(rowIndex) || defaultHeight; // lineCount overrides are stored in the heights cache
        } else {
          return defaultHeight; // default lineCount height is set in minRowHeight state in grid_row_body
        }
      }

      if (heightOption === AUTO_HEIGHT && rowIndex != null) {
        return this.getRowHeight(rowIndex);
      }

      return defaultHeight;
    }
    /**
     * Styles utils
     */

  }, {
    key: "cacheStyles",
    value: function cacheStyles(gridStyles) {
      this.styles = {
        paddingTop: cellPaddingsMap[gridStyles.cellPadding || 'm'],
        paddingBottom: cellPaddingsMap[gridStyles.cellPadding || 'm']
      };
    }
  }, {
    key: "getLineCount",
    value:
    /**
     * Line count utils
     */
    function getLineCount(option) {
      return (0, _predicate.isObject)(option) ? option.lineCount : undefined;
    }
  }, {
    key: "calculateHeightForLineCount",
    value: function calculateHeightForLineCount(cellRef, lineCount, excludePadding) {
      var computedStyles = window.getComputedStyle(cellRef, null);
      var lineHeight = parseInt(computedStyles.lineHeight, 10);
      var contentHeight = Math.ceil(lineCount * lineHeight);
      return excludePadding ? contentHeight : contentHeight + this.styles.paddingTop + this.styles.paddingBottom;
    }
    /**
     * Auto height utils
     */

  }, {
    key: "isAutoHeight",
    value: function isAutoHeight(rowIndex, rowHeightsOptions) {
      var height = this.getRowHeightOption(rowIndex, rowHeightsOptions);

      if (height === AUTO_HEIGHT) {
        return true;
      }

      return false;
    }
  }, {
    key: "getRowHeight",
    value: function getRowHeight(rowIndex) {
      var rowHeights = this.heightsCache.get(rowIndex);
      if (rowHeights == null) return 0;
      var rowHeightValues = Array.from(rowHeights.values());
      if (!rowHeightValues.length) return 0;
      return Math.max.apply(Math, _toConsumableArray(rowHeightValues));
    }
  }, {
    key: "setRowHeight",
    value: function setRowHeight(rowIndex, colId) {
      var _this$rerenderGridBod, _this$rerenderGridBod2;

      var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : DEFAULT_ROW_HEIGHT;
      var visibleRowIndex = arguments.length > 3 ? arguments[3] : undefined;
      var rowHeights = this.heightsCache.get(rowIndex) || new Map();
      var adaptedHeight = Math.ceil(height + this.styles.paddingTop + this.styles.paddingBottom);

      if (rowHeights.get(colId) === adaptedHeight) {
        return;
      }

      rowHeights.set(colId, adaptedHeight);
      this.heightsCache.set(rowIndex, rowHeights);
      this.resetRow(visibleRowIndex); // When an auto row height is updated, force a re-render
      // of the grid body to update the unconstrained height

      (_this$rerenderGridBod = (_this$rerenderGridBod2 = this.rerenderGridBodyRef).current) === null || _this$rerenderGridBod === void 0 ? void 0 : _this$rerenderGridBod.call(_this$rerenderGridBod2);
    }
  }, {
    key: "pruneHiddenColumnHeights",
    value: function pruneHiddenColumnHeights(visibleColumns) {
      var visibleColumnIds = new Set(visibleColumns.map(function (_ref) {
        var id = _ref.id;
        return id;
      }));
      var didModify = false;
      this.heightsCache.forEach(function (rowHeights) {
        var existingColumnIds = Array.from(rowHeights.keys());
        existingColumnIds.forEach(function (existingColumnId) {
          if (visibleColumnIds.has(existingColumnId) === false) {
            didModify = true;
            rowHeights.delete(existingColumnId);
          }
        });
      });

      if (didModify) {
        this.resetRow(0);
      }
    }
  }, {
    key: "resetRow",
    value: function resetRow(visibleRowIndex) {
      var _this2 = this;

      // save the first row index of batch, reassigning it only
      // if this visible row index less than lastUpdatedRow
      this.lastUpdatedRow = Math.min(this.lastUpdatedRow, visibleRowIndex);
      clearTimeout(this.timerId);
      this.timerId = window.setTimeout(function () {
        return _this2.resetGrid();
      }, 0);
    }
  }, {
    key: "resetGrid",
    value: function resetGrid() {
      var _this$gridRef$current;

      (_this$gridRef$current = this.gridRef.current) === null || _this$gridRef$current === void 0 ? void 0 : _this$gridRef$current.resetAfterRowIndex(this.lastUpdatedRow);
      this.lastUpdatedRow = Infinity;
    }
  }, {
    key: "compensateForLayoutShift",
    value: function compensateForLayoutShift(rowIndex, verticalLayoutShift, anchorRow) {
      var grid = this.gridRef.current;
      var outerGridElement = this.outerGridElementRef.current;
      var renderedItems = this.gridItemsRenderedRef.current;

      if (grid == null || outerGridElement == null || renderedItems == null || anchorRow == null || !Number.isFinite(verticalLayoutShift)) {
        return;
      } // skip if the start row is the anchor row but it hasn't shifted


      if (anchorRow === 'start' && renderedItems.visibleRowStartIndex !== rowIndex) {
        return;
      } // skip if the center row is the anchor row but it hasn't shifted


      if (anchorRow === 'center' && Math.floor((renderedItems.visibleRowStopIndex - renderedItems.visibleRowStartIndex) / 2) !== rowIndex) {
        return;
      }

      grid.scrollTo({
        scrollTop: outerGridElement.scrollTop + verticalLayoutShift
      });
    }
  }]);

  return RowHeightUtils;
}();
/**
 * Hook for instantiating RowHeightUtils, setting internal class vars,
 * and setting up various row-height-related side effects
 */


exports.RowHeightUtils = RowHeightUtils;

var useRowHeightUtils = function useRowHeightUtils(_ref2) {
  var gridRef = _ref2.gridRef,
      outerGridElementRef = _ref2.outerGridElementRef,
      gridItemsRenderedRef = _ref2.gridItemsRenderedRef,
      gridStyles = _ref2.gridStyles,
      columns = _ref2.columns,
      rowHeightsOptions = _ref2.rowHeightsOptions;
  var forceRenderRef = (0, _services.useLatest)((0, _services.useForceRender)());

  var _useState = (0, _react.useState)(function () {
    return new RowHeightUtils(gridRef, outerGridElementRef, gridItemsRenderedRef, forceRenderRef);
  }),
      _useState2 = _slicedToArray(_useState, 1),
      rowHeightUtils = _useState2[0]; // Forces a rerender whenever the row heights change, as this can cause the
  // grid to change height/have scrollbars. Without this, grid rerendering is stale


  (0, _react.useEffect)(function () {
    if (forceRenderRef.current == null) {
      return;
    }

    requestAnimationFrame(forceRenderRef.current);
  }, [// Effects that should cause rerendering
  rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight, rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.rowHeights, // Dependencies
  rowHeightUtils, forceRenderRef]); // Re-cache styles whenever grid density changes

  (0, _react.useEffect)(function () {
    rowHeightUtils.cacheStyles({
      cellPadding: gridStyles.cellPadding
    });
  }, [gridStyles.cellPadding, rowHeightUtils]); // Update row heights map to remove hidden columns whenever orderedVisibleColumns change

  (0, _react.useEffect)(function () {
    rowHeightUtils.pruneHiddenColumnHeights(columns);
  }, [rowHeightUtils, columns]);
  return rowHeightUtils;
};

exports.useRowHeightUtils = useRowHeightUtils;

var useDefaultRowHeight = function useDefaultRowHeight(_ref3) {
  var rowHeightsOptions = _ref3.rowHeightsOptions,
      rowHeightUtils = _ref3.rowHeightUtils;

  var _useContext = (0, _react.useContext)(_sorting.DataGridSortingContext),
      getCorrectRowIndex = _useContext.getCorrectRowIndex; // `minRowHeight` is primarily used by undefined & lineCount heights
  // and ignored by auto & static heights (unless the static height is < the min)


  var _useState3 = (0, _react.useState)(DEFAULT_ROW_HEIGHT),
      _useState4 = _slicedToArray(_useState3, 2),
      minRowHeight = _useState4[0],
      setRowHeight = _useState4[1]; // Default/fallback height for all rows


  var defaultRowHeight = (0, _react.useMemo)(function () {
    return rowHeightsOptions !== null && rowHeightsOptions !== void 0 && rowHeightsOptions.defaultHeight ? rowHeightUtils.getCalculatedHeight(rowHeightsOptions.defaultHeight, minRowHeight) : minRowHeight;
  }, [rowHeightsOptions, minRowHeight, rowHeightUtils]); // Used by react-window's Grid component to determine actual row heights

  var getRowHeight = (0, _react.useCallback)(function (rowIndex) {
    var correctRowIndex = getCorrectRowIndex(rowIndex);
    var rowHeight; // Account for row-specific height overrides

    var rowHeightOption = rowHeightUtils.getRowHeightOption(correctRowIndex, rowHeightsOptions);

    if (rowHeightOption) {
      rowHeight = rowHeightUtils.getCalculatedHeight(rowHeightOption, minRowHeight, correctRowIndex, rowHeightUtils.isRowHeightOverride(correctRowIndex, rowHeightsOptions));
    } // Use the row-specific height if it exists, if not, fall back to the default


    return rowHeight || defaultRowHeight;
  }, [minRowHeight, rowHeightsOptions, getCorrectRowIndex, rowHeightUtils, defaultRowHeight]);
  return {
    defaultRowHeight: defaultRowHeight,
    setRowHeight: setRowHeight,
    getRowHeight: getRowHeight
  };
};

exports.useDefaultRowHeight = useDefaultRowHeight;