"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiExpressionValueStyles = exports.euiExpressionStyles = exports.euiExpressionIconStyles = exports.euiExpressionDescriptionStyles = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

var _color = require("../../services/color");

function _objectDestructuringEmpty(obj) { if (obj == null) throw new TypeError("Cannot destructure undefined"); }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var _colorCSS = function _colorCSS(color) {
  return "\n    &:focus {\n      background-color: ".concat((0, _color.transparentize)(color, 0.1), ";\n    }\n  ");
};

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "6151l-base",
  styles: "border-bottom-style:solid;label:base;"
} : {
  name: "6151l-base",
  styles: "border-bottom-style:solid;label:base;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1372s1f-truncate",
  styles: "max-width:100%;label:truncate;"
} : {
  name: "1372s1f-truncate",
  styles: "max-width:100%;label:truncate;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiExpressionStyles = function euiExpressionStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiExpression: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextBreakWord)(), ";font-family:", euiTheme.font.familyCode, ";border-bottom:", euiTheme.border.width.thick, " solid transparent;", (0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";display:inline-block;text-align:left;padding:calc(", euiTheme.size.s, " / 2) 0;color:", euiTheme.colors.text, ";&:focus{border-bottom-style:solid;}&+.euiExpression{", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.s), ";};label:euiExpression;"),
    // Variants
    columns: /*#__PURE__*/(0, _react.css)("border-color:transparent;border-bottom-style:solid;", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.xs), " width:100%;display:flex;padding:", euiTheme.size.xs, ";border-radius:", euiTheme.size.xs, ";;label:columns;"),
    truncate: _ref4,
    // States
    isClickable: /*#__PURE__*/(0, _react.css)("cursor:pointer;border-bottom:", euiTheme.border.editable, ";&[class*='-columns']{background-color:", euiTheme.colors.lightestShade, ";&:focus,&:hover:not(:disabled){[class*='euiExpression__description'],[class*='euiExpression__value']{text-decoration:underline;}}};label:isClickable;"),
    isActive: {
      base: _ref3,
      subdued: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.subduedText, ";;label:subdued;"),
      primary: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.primary, ";;label:primary;"),
      success: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.success, ";;label:success;"),
      warning: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.warning, ";;label:warning;"),
      danger: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.danger, ";;label:danger;"),
      accent: /*#__PURE__*/(0, _react.css)("border-color:", euiTheme.colors.accent, ";;label:accent;")
    },
    subdued: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.subduedText), ";label:subdued;"),
    primary: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.primaryText), ";label:primary;"),
    success: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.successText), ";label:success;"),
    warning: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.warningText), ";label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.dangerText), ";label:danger;"),
    accent: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.accentText), ";label:accent;")
  };
};

exports.euiExpressionStyles = euiExpressionStyles;

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "shrg0y-isUppercase",
  styles: "text-transform:uppercase;label:isUppercase;"
} : {
  name: "shrg0y-isUppercase",
  styles: "text-transform:uppercase;label:isUppercase;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiExpressionDescriptionStyles = function euiExpressionDescriptionStyles(_ref5) {
  var euiTheme = _ref5.euiTheme;
  return {
    euiExpression__description: /*#__PURE__*/(0, _react.css)(";label:euiExpression__description;"),
    truncate: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " display:inline-block;vertical-align:bottom;;label:truncate;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.successText, ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.warningText, ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.dangerText, ";;label:danger;"),
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.accentText, ";;label:accent;"),
    isUppercase: _ref2,
    columns: /*#__PURE__*/(0, _react.css)("text-align:end;", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.s), ";flex-shrink:0;;label:columns;")
  };
};

exports.euiExpressionDescriptionStyles = euiExpressionDescriptionStyles;

var _ref = process.env.NODE_ENV === "production" ? {
  name: "29cdh2-columns",
  styles: "flex-grow:1;label:columns;"
} : {
  name: "29cdh2-columns",
  styles: "flex-grow:1;label:columns;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiExpressionValueStyles = function euiExpressionValueStyles(_ref6) {
  _objectDestructuringEmpty(_ref6);

  return {
    euiExpression__value: /*#__PURE__*/(0, _react.css)(";label:euiExpression__value;"),
    truncate: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " display:inline-block;vertical-align:bottom;;label:truncate;"),
    columns: _ref
  };
};

exports.euiExpressionValueStyles = euiExpressionValueStyles;

var euiExpressionIconStyles = function euiExpressionIconStyles(_ref7) {
  var euiTheme = _ref7.euiTheme;
  return {
    euiExpression__icon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), ";;label:euiExpression__icon;"),
    columns: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-top', euiTheme.size.xs), ";;label:columns;")
  };
};

exports.euiExpressionIconStyles = euiExpressionIconStyles;