"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.iconLoadingOpacity = exports.euiIconStyles = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

var _templateObject;

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var iconSize = function iconSize(size) {
  return "\n    ".concat((0, _global_styling.logicalCSS)('width', size), ";\n    ").concat((0, _global_styling.logicalCSS)('height', size), ";\n  ");
};

var iconLoadingOpacity = 0.05;
exports.iconLoadingOpacity = iconLoadingOpacity;
var iconLoading = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    opacity: ", ";\n  }\n\n  100% {\n    opacity: 1;\n  }\n"])), iconLoadingOpacity);

var _ref = process.env.NODE_ENV === "production" ? {
  name: "njd749-logoElasticOutline",
  styles: "*[fill]{fill:none!important;}.outline{fill:currentColor!important;};label:logoElasticOutline;"
} : {
  name: "njd749-logoElasticOutline",
  styles: "*[fill]{fill:none!important;}.outline{fill:currentColor!important;};label:logoElasticOutline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "uacjc5-inherit",
  styles: "color:inherit;label:inherit;"
} : {
  name: "uacjc5-inherit",
  styles: "color:inherit;label:inherit;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiIconStyles = function euiIconStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    // Base
    euiIcon: /*#__PURE__*/(0, _react.css)("flex-shrink:0;display:inline-block;vertical-align:middle;fill:currentColor;transform:translate(0, 0);.euiIcon__fillNegative{fill:", euiTheme.colors.darkestShade, ";};label:euiIcon;"),
    // Colors
    accent: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.accentText, ";;label:accent;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.dangerText, ";;label:danger;"),
    ghost: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.ghost, ";*[fill],.euiIcon__fillNegative{fill:currentColor!important;};label:ghost;"),
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.successText, ";;label:success;"),
    subdued: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.subduedText, ";;label:subdued;"),
    text: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.title, ";*[fill],.euiIcon__fillNegative{fill:currentColor!important;};label:text;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.warningText, ";;label:warning;"),
    inherit: _ref2,
    default: /*#__PURE__*/(0, _react.css)(";label:default;"),
    customColor: /*#__PURE__*/(0, _react.css)(";label:customColor;"),
    logoElasticOutline: _ref,
    // Sizes
    original: /*#__PURE__*/(0, _react.css)(";label:original;"),
    s: /*#__PURE__*/(0, _react.css)(iconSize(euiTheme.size.m), ";label:s;"),
    m: /*#__PURE__*/(0, _react.css)(iconSize(euiTheme.size.base), ";label:m;"),
    l: /*#__PURE__*/(0, _react.css)(iconSize(euiTheme.size.l), ";label:l;"),
    xl: /*#__PURE__*/(0, _react.css)(iconSize(euiTheme.size.xl), ";label:xl;"),
    xxl: /*#__PURE__*/(0, _react.css)(iconSize(euiTheme.size.xxl), ";label:xxl;"),
    // Variants
    // App icons are two-toned. This provides the base color.
    app: /*#__PURE__*/(0, _react.css)("fill:", euiTheme.colors.text, ";.euiIcon__fillSecondary{fill:", euiTheme.colors.successText, ";};label:app;"),
    logo: /*#__PURE__*/(0, _react.css)(";label:logo;"),
    // Loading states
    isLoading: /*#__PURE__*/(0, _react.css)("opacity:", iconLoadingOpacity, ";background-color:currentColor;border-radius:", euiTheme.border.radius.small, ";;label:isLoading;"),
    isLoaded: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{animation:", iconLoading, " ", euiTheme.animation.normal, " ease-in 0s 1 forwards;};label:isLoaded;")
  };
};

exports.euiIconStyles = euiIconStyles;