"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiImageCaptionStyles = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

var _services = require("../../services");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiImageCaptionStyles = function euiImageCaptionStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiImageCaption: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.xs), ";;label:euiImageCaption;"),
    isOnOverlayMask: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.ghost, ";text-shadow:0 1px 2px ", (0, _services.transparentize)(euiTheme.colors.ink, 0.6), ";[class*='euiLink']{color:", euiTheme.colors.ghost, ";};label:isOnOverlayMask;")
  };
};

exports.euiImageCaptionStyles = euiImageCaptionStyles;