"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiImageWrapperStyles = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var _ref = process.env.NODE_ENV === "production" ? {
  name: "gacnmc-allowFullScreen",
  styles: "&:hover [class*='euiImageCaption']{text-decoration:underline;};label:allowFullScreen;"
} : {
  name: "gacnmc-allowFullScreen",
  styles: "&:hover [class*='euiImageCaption']{text-decoration:underline;};label:allowFullScreen;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiImageWrapperStyles = function euiImageWrapperStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiImageWrapper: /*#__PURE__*/(0, _react.css)("display:inline-block;", (0, _global_styling.logicalCSS)('max-width', '100%'), " ", (0, _global_styling.logicalTextAlignCSS)('center'), ";line-height:0;flex-shrink:0;;label:euiImageWrapper;"),
    allowFullScreen: _ref,
    // Margins
    s: /*#__PURE__*/(0, _react.css)("margin:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("margin:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("margin:", euiTheme.size.l, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("margin:", euiTheme.size.xl, ";;label:xl;"),
    // Floats
    // 1: Logical properties/values in `float` is currently not yet supported by all browsers w/o flags
    // @see https://caniuse.com/mdn-css_properties_float_flow_relative_values for when we can remove left/right fallbacks
    left: /*#__PURE__*/(0, _react.css)("@media only screen and (min-width: ", euiTheme.breakpoint.m, "px){float:left;float:", _global_styling.logicalSide.left, ";", (0, _global_styling.logicalCSS)('margin-left', '0'), ";", (0, _global_styling.logicalCSS)('margin-top', '0'), ";};label:left;"),
    right: /*#__PURE__*/(0, _react.css)("@media only screen and (min-width: ", euiTheme.breakpoint.m, "px){float:right;float:", _global_styling.logicalSide.right, ";", (0, _global_styling.logicalCSS)('margin-right', '0'), ";", (0, _global_styling.logicalCSS)('margin-top', '0'), ";};label:right;"),
    // Sizes
    fullWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:fullWidth;")
  };
};

exports.euiImageWrapperStyles = euiImageWrapperStyles;