"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiLoadingSpinnerStyles = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

var _templateObject;

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

var _loadingSpinner = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    transform: rotate(0deg);\n  }\n\n  to {\n    transform: rotate(359deg);\n  }\n"])));

var spinnerSizes = {
  s: 'm',
  m: 'base',
  l: 'l',
  xl: 'xl',
  xxl: 'xxl'
};

var spinnerColorsCSS = function spinnerColorsCSS(border, highlight) {
  return "\n    border-color: ".concat(highlight, " ").concat(border, " ").concat(border, " ").concat(border, ";\n  ");
};

var euiLoadingSpinnerStyles = function euiLoadingSpinnerStyles(_ref, color) {
  var euiTheme = _ref.euiTheme;
  return {
    euiLoadingSpinner: /*#__PURE__*/(0, _react.css)("flex-shrink:0;display:inline-block;border-radius:50%;border:", euiTheme.border.thick, ";", spinnerColorsCSS((color === null || color === void 0 ? void 0 : color.border) || euiTheme.colors.lightShade, (color === null || color === void 0 ? void 0 : color.highlight) || euiTheme.colors.primary), ";", _global_styling.euiCanAnimate, "{animation:", _loadingSpinner, " 0.6s infinite linear;};label:euiLoadingSpinner;"),
    // Sizes
    s: /*#__PURE__*/(0, _react.css)("width:", euiTheme.size[spinnerSizes.s], ";height:", euiTheme.size[spinnerSizes.s], ";border-width:calc(", euiTheme.border.width.thin, " * 1.5);;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("width:", euiTheme.size[spinnerSizes.m], ";height:", euiTheme.size[spinnerSizes.m], ";border-width:calc(", euiTheme.border.width.thin, " * 1.5);;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("width:", euiTheme.size[spinnerSizes.l], ";height:", euiTheme.size[spinnerSizes.l], ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("width:", euiTheme.size[spinnerSizes.xl], ";height:", euiTheme.size[spinnerSizes.xl], ";;label:xl;"),
    xxl: /*#__PURE__*/(0, _react.css)("width:", euiTheme.size[spinnerSizes.xxl], ";height:", euiTheme.size[spinnerSizes.xxl], ";;label:xxl;")
  };
};

exports.euiLoadingSpinnerStyles = euiLoadingSpinnerStyles;