"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMark = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../i18n");

var _services = require("../../services");

var _mark = require("./mark.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "hasScreenReaderHelpText"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiMark = function EuiMark(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$hasScreenReaderH = _ref.hasScreenReaderHelpText,
      hasScreenReaderHelpText = _ref$hasScreenReaderH === void 0 ? true : _ref$hasScreenReaderH,
      rest = _objectWithoutProperties(_ref, _excluded);

  var useTheme = (0, _services.useEuiTheme)();
  var highlightStart = (0, _i18n.useEuiI18n)('euiMark.highlightStart', 'highlight start');
  var highlightEnd = (0, _i18n.useEuiI18n)('euiMark.highlightEnd', 'highlight end');
  var styles = (0, _mark.euiMarkStyles)(useTheme, {
    hasScreenReaderHelpText: hasScreenReaderHelpText,
    highlightStart: highlightStart,
    highlightEnd: highlightEnd
  });
  var classes = (0, _classnames.default)('euiMark', className);
  return (0, _react2.jsx)("mark", _extends({
    css: [styles, ";label:EuiMark;"],
    className: classes
  }, rest), children);
};

exports.EuiMark = EuiMark;
EuiMark.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
       * Set to `false` to remove the CSS :before and :after
       * screen reader helper text
       */
  hasScreenReaderHelpText: _propTypes.default.bool,

  /**
       * ReactNode to render as this component's content
       */
  children: _propTypes.default.node.isRequired
};