"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPage = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _restrict_width = require("./_restrict_width");

var _global_styling = require("../../global_styling");

var _page = require("./page.styles");

var _services = require("../../services");

var _react2 = require("@emotion/react");

var _excluded = ["children", "restrictWidth", "className", "paddingSize", "grow", "direction"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiPage = function EuiPage(_ref) {
  var children = _ref.children,
      _ref$restrictWidth = _ref.restrictWidth,
      restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
      className = _ref.className,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? 'row' : _ref$direction,
      rest = _objectWithoutProperties(_ref, _excluded);

  // Set max-width as a style prop
  var widthStyles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, rest === null || rest === void 0 ? void 0 : rest.style);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _page.euiPageStyles)(euiTheme);
  var padding = (0, _global_styling.useEuiPaddingCSS)()[paddingSize];
  var stylesCSS = [styles.euiPage, styles[direction], grow && styles.grow, padding, restrictWidth && styles.restrictWidth];
  var classes = (0, _classnames.default)('euiPage', className);
  return (0, _react2.jsx)("div", _extends({
    css: stylesCSS,
    className: classes
  }, rest, {
    style: widthStyles
  }), children);
};

exports.EuiPage = EuiPage;
EuiPage.propTypes = {
  /**
     * Adjust the padding.
     * When using this setting it's best to be consistent throughout all similar usages
     */
  paddingSize: _propTypes.default.any,

  /**
     * Adds `flex-grow: 1` to the whole page for stretching to fit vertically.
     * Must be wrapped inside a flexbox, preferrably with `min-height: 100vh`
     */
  grow: _propTypes.default.bool,

  /**
     * Changes the `flex-direction` property.
     * Flip to `column` when not including a sidebar.
     */
  direction: _propTypes.default.oneOf(["row", "column"]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired])
};