"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageHeaderContent = exports.ALIGN_ITEMS = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../../icon");

var _tabs = require("../../tabs");

var _flex = require("../../flex");

var _spacer = require("../../spacer");

var _title = require("../../title");

var _text = require("../../text");

var _services = require("../../../services");

var _accessibility = require("../../accessibility");

var _breadcrumbs = require("../../breadcrumbs");

var _global_styling = require("../../../global_styling");

var _restrict_width = require("../_restrict_width");

var _page_header = require("./page_header.styles");

var _page_header_content = require("./page_header_content.styles");

var _react2 = require("@emotion/react");

var _excluded = ["className", "pageTitle", "pageTitleProps", "iconType", "iconProps", "tabs", "tabsProps", "description", "breadcrumbs", "breadcrumbProps", "alignItems", "responsive", "rightSideItems", "rightSideGroupProps", "children", "restrictWidth", "paddingSize", "bottomBorder", "style"],
    _excluded2 = ["label"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var ALIGN_ITEMS = ['top', 'bottom', 'center', 'stretch']; // Gets all the tab props including the button or link props

exports.ALIGN_ITEMS = ALIGN_ITEMS;

var EuiPageHeaderContent = function EuiPageHeaderContent(_ref) {
  var className = _ref.className,
      pageTitle = _ref.pageTitle,
      pageTitleProps = _ref.pageTitleProps,
      iconType = _ref.iconType,
      iconProps = _ref.iconProps,
      tabs = _ref.tabs,
      tabsProps = _ref.tabsProps,
      description = _ref.description,
      breadcrumbs = _ref.breadcrumbs,
      breadcrumbProps = _ref.breadcrumbProps,
      alignItems = _ref.alignItems,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? true : _ref$responsive,
      rightSideItems = _ref.rightSideItems,
      rightSideGroupProps = _ref.rightSideGroupProps,
      children = _ref.children,
      restrictWidth = _ref.restrictWidth,
      _ref$paddingSize = _ref.paddingSize,
      _paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
      _bottom_border = _ref.bottomBorder,
      style = _ref.style,
      rest = _objectWithoutProperties(_ref, _excluded);

  var isResponsiveBreakpoint = (0, _services.useIsWithinBreakpoints)(['xs', 's'], !!responsive);
  var useTheme = (0, _services.useEuiTheme)();
  var classes = (0, _classnames.default)('euiPageHeaderContent', className);
  var pageHeaderStyles = (0, _page_header.euiPageHeaderStyles)(useTheme);
  var contentStyles = (0, _page_header_content.euiPageHeaderContentStyles)(useTheme);
  var styles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, style);
  var paddingSides = 'vertical';
  var paddingSize = _paddingSize;
  var bottomBorder = _bottom_border;
  var onlyChildren = !tabs && !pageTitle && !rightSideItems && !description && children;
  var onlyTabs = tabs && !pageTitle && !rightSideItems && !description && !children;
  var tabsAsTitle = tabs && !pageTitle;
  var tabsAtTheBottom = pageTitle && tabs;
  var borderWithoutPadding = (!paddingSize || paddingSize === 'none') && bottomBorder;

  if (onlyTabs) {
    paddingSize = 'none';
  } else if (tabsAsTitle) {
    paddingSides = 'bottom';
  } else if (tabsAtTheBottom) {
    paddingSides = 'top';
    bottomBorder = bottomBorder === false ? false : true;
  } else if (borderWithoutPadding) {
    paddingSides = 'bottom';
    paddingSize = 'l';
  }

  var blockPadding = (0, _global_styling.useEuiPaddingCSS)(paddingSides);
  var cssStyles = [contentStyles.euiPageHeaderContent, bottomBorder && pageHeaderStyles.border, blockPadding[paddingSize]];
  var childrenOnlyStyles = [contentStyles.flex, contentStyles[alignItems || 'center'], responsive === true && isResponsiveBreakpoint && contentStyles.responsive, responsive === 'reverse' && isResponsiveBreakpoint && contentStyles.responsiveReverse]; // Don't go any further if there's no other content than children

  if (onlyChildren) {
    return (0, _react2.jsx)("div", _extends({
      css: cssStyles
    }, rest), (0, _react2.jsx)("div", {
      css: childrenOnlyStyles
    }, children));
  }

  var descriptionNode;

  if (description) {
    descriptionNode = (0, _react2.jsx)(_react.default.Fragment, null, (pageTitle || tabs) && (0, _react2.jsx)(_spacer.EuiSpacer, null), (0, _react2.jsx)(_text.EuiText, {
      grow: false
    }, (0, _react2.jsx)("p", null, description)));
  }

  var optionalBreadcrumbs = breadcrumbs ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_breadcrumbs.EuiBreadcrumbs, _extends({
    breadcrumbs: breadcrumbs
  }, breadcrumbProps)), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  })) : undefined;
  var pageTitleNode;

  if (pageTitle) {
    var icon = iconType ? (0, _react2.jsx)(_icon.EuiIcon, _extends({
      size: "xl",
      css: contentStyles.euiPageHeaderContent__titleIcon
    }, iconProps, {
      type: iconType
    })) : undefined;
    pageTitleNode = (0, _react2.jsx)(_title.EuiTitle, _extends({}, pageTitleProps, {
      size: "l"
    }), (0, _react2.jsx)("h1", null, icon, pageTitle));
  }

  var tabsNode;

  if (tabs) {
    var _tabs$find;

    var tabsSize = pageTitle ? 'l' : 'xl';

    var renderTabs = function renderTabs() {
      return tabs.map(function (tab, index) {
        var label = tab.label,
            tabRest = _objectWithoutProperties(tab, _excluded2);

        return (0, _react2.jsx)(_tabs.EuiTab, _extends({
          key: index
        }, tabRest), label);
      });
    }; // When tabs exist without a pageTitle, we need to recreate an h1 based on the currently selected tab and visually hide it


    var screenReaderPageTitle = !pageTitle && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("h1", null, (_tabs$find = tabs.find(function (obj) {
      return obj.isSelected === true;
    })) === null || _tabs$find === void 0 ? void 0 : _tabs$find.label));
    tabsNode = (0, _react2.jsx)(_react.default.Fragment, null, pageTitleNode && (0, _react2.jsx)(_spacer.EuiSpacer, null), screenReaderPageTitle, (0, _react2.jsx)(_tabs.EuiTabs, _extends({}, tabsProps, {
      bottomBorder: false,
      size: tabsSize
    }), renderTabs()));
  }

  var childrenNode = children && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_spacer.EuiSpacer, null), children);
  var bottomContentNode;

  if (childrenNode || tabsNode && pageTitleNode) {
    bottomContentNode = (0, _react2.jsx)("div", {
      className: "euiPageHeaderContent__bottom"
    }, childrenNode, pageTitleNode && tabsNode);
  }
  /**
   * The left side order depends on if a `pageTitle` was supplied.
   * If not, but there are `tabs`, then the tabs become the page title
   */


  var leftSideOrder;

  if (tabsNode && !pageTitleNode) {
    leftSideOrder = (0, _react2.jsx)(_react.default.Fragment, null, tabsNode, descriptionNode);
  } else {
    leftSideOrder = (0, _react2.jsx)(_react.default.Fragment, null, pageTitleNode, descriptionNode);
  }

  var rightSideFlexItem;

  if (rightSideItems && rightSideItems.length) {
    var wrapWithFlex = function wrapWithFlex() {
      return rightSideItems.map(function (item, index) {
        return (0, _react2.jsx)(_flex.EuiFlexItem, {
          grow: false,
          key: index
        }, item);
      });
    };

    rightSideFlexItem = (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_flex.EuiFlexGroup, _extends({
      wrap: true,
      responsive: false,
      direction: isResponsiveBreakpoint ? undefined : 'rowReverse'
    }, rightSideGroupProps), wrapWithFlex()));
  }

  return alignItems === 'top' || isResponsiveBreakpoint ? (0, _react2.jsx)("div", _extends({
    className: classes,
    css: cssStyles,
    style: styles
  }, rest), optionalBreadcrumbs, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    responsive: !!responsive,
    className: "euiPageHeaderContent__top",
    alignItems: pageTitle ? 'flexStart' : 'baseline',
    gutterSize: "l"
  }, isResponsiveBreakpoint && responsive === 'reverse' ? (0, _react2.jsx)(_react.default.Fragment, null, rightSideFlexItem, (0, _react2.jsx)(_flex.EuiFlexItem, null, leftSideOrder)) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_flex.EuiFlexItem, null, leftSideOrder), rightSideFlexItem)), bottomContentNode) : (0, _react2.jsx)("div", _extends({
    className: classes,
    css: cssStyles,
    style: styles
  }, rest), optionalBreadcrumbs, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    responsive: !!responsive,
    className: "euiPageHeaderContent__top",
    alignItems: alignItems === 'bottom' ? 'flexEnd' : alignItems,
    gutterSize: "l"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, leftSideOrder, bottomContentNode), rightSideFlexItem));
};

exports.EuiPageHeaderContent = EuiPageHeaderContent;
EuiPageHeaderContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
     * The only option is on/off
     */
  bottomBorder: _propTypes.default.bool,

  /**
     * Adjust the padding.
     * When using this setting it's best to be consistent throughout all similar usages
     */
  paddingSize: _propTypes.default.any,

  /**
     * Set to false if you don't want the children to stack at small screen sizes.
     * Set to `reverse` to display the right side content first for the sake of hierarchy (like global time)
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["reverse"])]),

  /**
     * Vertical alignment of the left and right side content;
     * Default is `center` for custom content, but `top` for when `pageTitle` or `tabs` are included
     */
  alignItems: _propTypes.default.any,

  /**
     * Pass custom an array of content to this side usually up to 3 buttons.
     * The first button should be primary, usually with `fill` and will be visually displayed as the last item,
     * but first in the tab order
     */
  rightSideItems: _propTypes.default.arrayOf(_propTypes.default.node.isRequired),

  /**
     * Additional EuiFlexGroup props to pass to the container of the `rightSideItems`
     */
  rightSideGroupProps: _propTypes.default.any,

  /**
     * Custom children will be rendered before the `tabs` unless no `pageTitle` is present, then it will be the last item
     */
  children: _propTypes.default.node,

  /**
     * Position is dependent on existing with a `pageTitle` or `tabs`
     * Automatically get wrapped in a single paragraph tag inside an EuiText block
     */
  description: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.node.isRequired]),

  /**
     * Wrapped in an `H1` so choose appropriately.
     * A simple string is best
     */
  pageTitle: _propTypes.default.node,

  /**
     * Additional props to pass to the EuiTitle
     */
  pageTitleProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    textTransform: _propTypes.default.any,
    id: _propTypes.default.string
  }),

  /**
     * Optional icon to place to the left of the title
     */
  iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInACircleFilled", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "discoverApp", "document", "documentEdit", "documentation", "documents", "dot", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelionApp", "timeRefresh", "timeslider", "training", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDenseVector", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

  /**
     * Additional EuiIcon props to apply to the optional icon
     */
  iconProps: _propTypes.default.any,

  /**
     * Optional array breadcrumbs that render before the `pageTitle`
     */
  breadcrumbs: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    href: _propTypes.default.string,
    rel: _propTypes.default.string,
    onClick: _propTypes.default.func,

    /**
         * Visible label of the breadcrumb
         */
    text: _propTypes.default.node.isRequired,

    /**
         * Force a max-width on the breadcrumb text
         */
    truncate: _propTypes.default.bool,

    /**
         * Accepts any EuiLink `color` when rendered as one (has `href` or `onClick`)
         */
    color: _propTypes.default.any,

    /**
         * Override the existing `aria-current` which defaults to `page` for the last breadcrumb
         */
    "aria-current": _propTypes.default.any
  }).isRequired),

  /**
     * Adjust the props of [EuiBreadcrumbs](#/navigation/breadcrumbs)
     */
  breadcrumbProps: _propTypes.default.any,

  /**
     * In-app navigation presented as large borderless tabs.
     * Accepts an array of `EuiTab` objects;
     */
  tabs: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Visible text of the tab
       */
    label: _propTypes.default.node.isRequired
  }).isRequired),

  /**
     * Any extras to apply to the outer tabs container.
     * Extends `EuiTabs`
     */
  tabsProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,

    /**
         * ReactNode to render as this component's content
         */
    children: _propTypes.default.node,

    /**
         * Adds a bottom border to separate it from the content after
         */
    bottomBorder: _propTypes.default.bool
  }),

  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired])
};