"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageSection = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _restrict_width = require("../_restrict_width");

var _services = require("../../../services");

var _page_section = require("./page_section.styles");

var _global_styling = require("../../../global_styling");

var _react2 = require("@emotion/react");

var _excluded = ["children", "alignment", "restrictWidth", "bottomBorder", "paddingSize", "color", "grow", "contentProps", "component"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiPageSection = function EuiPageSection(_ref) {
  var children = _ref.children,
      _ref$alignment = _ref.alignment,
      alignment = _ref$alignment === void 0 ? 'top' : _ref$alignment,
      _ref$restrictWidth = _ref.restrictWidth,
      restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
      bottomBorder = _ref.bottomBorder,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'transparent' : _ref$color,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? false : _ref$grow,
      contentProps = _ref.contentProps,
      _ref$component = _ref.component,
      Component = _ref$component === void 0 ? 'section' : _ref$component,
      rest = _objectWithoutProperties(_ref, _excluded);

  // Set max-width as a style prop
  var widthStyles = (0, _restrict_width.setStyleForRestrictedPageWidth)(restrictWidth, contentProps === null || contentProps === void 0 ? void 0 : contentProps.style);
  var useTheme = (0, _services.useEuiTheme)();
  var styles = (0, _page_section.euiPageSectionStyles)(useTheme);
  var inlinePadding = (0, _global_styling.useEuiPaddingCSS)('horizontal');
  var blockPadding = (0, _global_styling.useEuiPaddingCSS)('vertical');
  var colors = (0, _global_styling.useEuiBackgroundColorCSS)();
  var cssStyles = [styles.euiPageSection, grow && styles.grow, inlinePadding[paddingSize], bottomBorder === 'extended' && styles.border, alignment && styles[alignment], colors[color]];
  var contentStyles = (0, _page_section.euiPageSectionContentStyles)();
  var cssContentStyles = [contentStyles.euiPageSection__content, blockPadding[paddingSize], bottomBorder === true && styles.border, alignment.toLowerCase().includes('center') && contentStyles.center, restrictWidth && contentStyles.restrictWidth, (contentProps === null || contentProps === void 0 ? void 0 : contentProps.css) && contentProps.css];
  return (0, _react2.jsx)(Component, _extends({
    css: cssStyles
  }, rest), (0, _react2.jsx)("div", _extends({}, contentProps, {
    css: cssContentStyles,
    style: widthStyles
  }), children));
};

exports.EuiPageSection = EuiPageSection;
EuiPageSection.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
     * Adds a bottom border to separate it from the content after;
     * Passing `extended` will ensure the border touches the sides of the parent container.
     */
  bottomBorder: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["extended"])]),

  /**
       * Background color of the section;
       * Usually a lightened form of the brand colors
       */
  color: _propTypes.default.any,

  /**
       * Padding for all four sides
       */
  paddingSize: _propTypes.default.any,

  /**
       * Horizontal and/or vertical alignment of the section contents
       */
  alignment: _propTypes.default.any,

  /**
       * When true the panel will grow in height to fill container if parent is a flex group
       */
  grow: _propTypes.default.bool,

  /**
       * Passed down to the div wrapper of the section contents
       */
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),

  /**
       * Sets which HTML element to render.
       */
  component: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.elementType.isRequired])
};