"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageTemplate = exports.TemplateContext = exports.EuiPageTemplate = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _outer = require("./outer");

var _inner = require("./inner");

var _page_bottom_bar = require("./bottom_bar/page_bottom_bar");

var _page_empty_prompt = require("./empty_prompt/page_empty_prompt");

var _page = require("../page");

var _services = require("../../services");

var _global_styling = require("../../global_styling");

var _react2 = require("@emotion/react");

var _excluded = ["children", "restrictWidth", "paddingSize", "grow", "bottomBorder", "offset", "panelled", "contentBorder", "mainProps", "className", "minHeight", "responsive"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var TemplateContext = /*#__PURE__*/(0, _react.createContext)({
  section: {},
  header: {},
  emptyPrompt: {},
  bottomBar: {}
});
exports.TemplateContext = TemplateContext;

/**
 * Consumed via `EuiPageTemplate`,
 * it controls and propogates most of the shared props per direct child
 */
var _EuiPageTemplate = function _EuiPageTemplate(_ref) {
  var children = _ref.children,
      _ref$restrictWidth = _ref.restrictWidth,
      restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      bottomBorder = _ref.bottomBorder,
      _offset = _ref.offset,
      panelled = _ref.panelled,
      contentBorder = _ref.contentBorder,
      mainProps = _ref.mainProps,
      className = _ref.className,
      _ref$minHeight = _ref.minHeight,
      minHeight = _ref$minHeight === void 0 ? '460px' : _ref$minHeight,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
      rest = _objectWithoutProperties(_ref, _excluded);

  var _useEuiTheme = (0, _services.useEuiTheme)(),
      euiTheme = _useEuiTheme.euiTheme;

  var _useState = (0, _react.useState)(_offset),
      _useState2 = _slicedToArray(_useState, 2),
      offset = _useState2[0],
      setOffset = _useState2[1];

  var templateContext = (0, _react.useContext)(TemplateContext); // Used as a target to insert the bottom bar component

  var pageInnerId = (0, _services.useGeneratedHtmlId)({
    prefix: 'EuiPageTemplateInner',
    conditionalId: mainProps === null || mainProps === void 0 ? void 0 : mainProps.id
  });
  (0, _react.useEffect)(function () {
    if (_offset === undefined) {
      var _document$body$datase;

      var euiHeaderFixedCounter = Number((_document$body$datase = document.body.dataset.fixedHeaders) !== null && _document$body$datase !== void 0 ? _document$body$datase : 0);
      setOffset(euiTheme.base * 3 * euiHeaderFixedCounter);
    }
  }, [_offset, euiTheme.base]); // Sections include page header

  var sections = [];
  var sidebar = [];

  var getBottomBorder = function getBottomBorder() {
    if (bottomBorder !== undefined) {
      return bottomBorder;
    } else {
      return sidebar.length ? true : 'extended';
    }
  };

  var getHeaderProps = function getHeaderProps() {
    return {
      restrictWidth: restrictWidth,
      paddingSize: paddingSize,
      bottomBorder: getBottomBorder()
    };
  };

  var getSectionProps = function getSectionProps() {
    return {
      restrictWidth: restrictWidth,
      paddingSize: paddingSize,
      color: panelled === false ? 'transparent' : 'plain'
    };
  };

  var getSideBarProps = function getSideBarProps() {
    return {
      paddingSize: paddingSize,
      responsive: responsive
    };
  };

  var getBottomBarProps = function getBottomBarProps() {
    return {
      restrictWidth: restrictWidth,
      paddingSize: paddingSize,
      parent: "#".concat(pageInnerId)
    };
  };

  var innerPanelled = function innerPanelled() {
    return panelled === false ? false : Boolean(sidebar.length > 0);
  };

  var innerBordered = function innerBordered() {
    return contentBorder !== undefined ? contentBorder : Boolean(sidebar.length > 0);
  };

  _react.default.Children.toArray(children).forEach(function (child, index) {
    if (! /*#__PURE__*/_react.default.isValidElement(child)) return; // Skip non-components

    switch (child.type) {
      case _page.EuiPageSidebar:
        sidebar.push( /*#__PURE__*/_react.default.cloneElement(child, _objectSpread(_objectSpread({
          key: "sidebar".concat(index)
        }, getSideBarProps()), child.props)));
        break;

      default:
        sections.push(child);
    }
  });

  var _minHeight = grow ? "max(".concat(minHeight, ", 100vh)") : minHeight;

  var classes = (0, _classnames.default)('euiPageTemplate', className);

  var pageStyle = _objectSpread(_objectSpread(_objectSpread({}, (0, _global_styling.logicalStyle)('min-height', _minHeight)), (0, _global_styling.logicalStyle)('padding-top', offset)), rest.style);

  templateContext.header = getHeaderProps();
  templateContext.section = getSectionProps();
  templateContext.emptyPrompt = {
    panelled: innerPanelled() ? true : panelled,
    grow: true
  };
  templateContext.bottomBar = getBottomBarProps();
  return (0, _react2.jsx)(TemplateContext.Provider, {
    value: templateContext
  }, (0, _react2.jsx)(_outer._EuiPageOuter, _extends({}, rest, {
    responsive: responsive,
    style: pageStyle,
    className: classes
  }), sidebar, (0, _react2.jsx)(_inner._EuiPageInner, _extends({}, mainProps, {
    id: pageInnerId,
    border: innerBordered(),
    panelled: innerPanelled(),
    responsive: responsive
  }), sections)));
};

exports._EuiPageTemplate = _EuiPageTemplate;
_EuiPageTemplate.propTypes = {
  /**
     * Adds `flex-grow: 1` to the whole page for stretching to fit vertically.
     * Must be wrapped inside a flexbox, preferrably with `min-height: 100vh`
     */
  grow: _propTypes.default.bool,

  /**
     * Changes the `flex-direction` property.
     * Flip to `column` when not including a sidebar.
     */
  direction: _propTypes.default.oneOf(["row", "column"]),

  /**
     * When direction is `row`, it will flip to `column` when within these breakpoints
     */
  responsive: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
     * Adds a bottom border to separate it from the content after;
     * Passing `extended` will ensure the border touches the sides of the parent container.
     */
  bottomBorder: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["extended"])]),

  /**
       * Applies a top or left border to the inner contents
       * to add separation between content and sidebar when a sidebar exists.
       */
  contentBorder: _propTypes.default.bool,

  /**
       * Minimum height in which to enforce scrolling
       */
  minHeight: _propTypes.default.any,

  /**
       * To account for any fixed elements like headers,
       * pass in the value of the total height of those fixed elements.
       * Otherwise they will be calculated based on the data attributes on the body element.
       */
  offset: _propTypes.default.number,

  /**
       * Passes through some common HTML attributes to the `main` content wrapper
       */
  mainProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  })
};

var _EuiPageSection = function _EuiPageSection(props) {
  var templateContext = (0, _react.useContext)(TemplateContext);
  return (0, _react2.jsx)(_page.EuiPageSection, _extends({}, templateContext.section, {
    grow: true
  }, props));
};

_EuiPageSection.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
       * Background color of the section;
       * Usually a lightened form of the brand colors
       */
  color: _propTypes.default.any,

  /**
       * Padding for all four sides
       */
  paddingSize: _propTypes.default.any,

  /**
       * Horizontal and/or vertical alignment of the section contents
       */
  alignment: _propTypes.default.any,

  /**
       * When true the panel will grow in height to fill container if parent is a flex group
       */
  grow: _propTypes.default.bool,

  /**
       * Passed down to the div wrapper of the section contents
       */
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),

  /**
       * Sets which HTML element to render.
       */
  component: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.elementType.isRequired])
};

var _EuiPageHeader = function _EuiPageHeader(props) {
  var templateContext = (0, _react.useContext)(TemplateContext);
  return (0, _react2.jsx)(_page.EuiPageHeader, _extends({}, templateContext.header, props));
};

_EuiPageHeader.propTypes = {
  /**
     * Adjust the overall padding.
     */
  paddingSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
     * Adds a bottom border to separate it from the content after;
     * Passing `extended` will ensure the border touches the sides of the parent container.
     */
  bottomBorder: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["extended"])])
};

var _EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(props) {
  var templateContext = (0, _react.useContext)(TemplateContext);
  return (0, _react2.jsx)(_page_empty_prompt._EuiPageEmptyPrompt, _extends({}, templateContext.emptyPrompt, props));
};

_EuiPageEmptyPrompt.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  color: _propTypes.default.any,
  paddingSize: _propTypes.default.any,
  alignment: _propTypes.default.any,
  grow: _propTypes.default.bool,
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  component: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.elementType.isRequired]),
  panelled: _propTypes.default.bool
};

var _EuiPageBottomBar = function _EuiPageBottomBar(props) {
  var _useContext = (0, _react.useContext)(TemplateContext),
      bottomBar = _useContext.bottomBar;

  return (0, _react2.jsx)(_page_bottom_bar._EuiPageBottomBar, _extends({}, bottomBar, props));
};

_EuiPageBottomBar.propTypes = {
  /**
     * The reference id of the element to insert into
     */
  parent: _propTypes.default.string,

  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired])
};
var EuiPageTemplate = Object.assign(_EuiPageTemplate, {
  Sidebar: _page.EuiPageSidebar,
  Header: _EuiPageHeader,
  Section: _EuiPageSection,
  BottomBar: _EuiPageBottomBar,
  EmptyPrompt: _EuiPageEmptyPrompt
});
exports.EuiPageTemplate = EuiPageTemplate;