"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPopoverTitleStyles = void 0;

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

var _title = require("../title/title.styles");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiPopoverTitleStyles = function euiPopoverTitleStyles(euiThemeContext, panelPadding) {
  var euiTheme = euiThemeContext.euiTheme; // If the popover's containing panel has padding applied,
  // ensure the title expands to cover that padding and

  var panelPaddingSize = (0, _global_styling.euiPaddingSize)(euiThemeContext, panelPadding);
  return {
    // Base
    euiPopoverTitle: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xxs'), ";", (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin), ";margin:-", panelPaddingSize, " -", panelPaddingSize, " ", panelPaddingSize, ";;label:euiPopoverTitle;")
  };
};

exports.euiPopoverTitleStyles = euiPopoverTitleStyles;