"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableHeader = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "wrapWithTableRow"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiTableHeader = function EuiTableHeader(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$wrapWithTableRow = _ref.wrapWithTableRow,
      wrapWithTableRow = _ref$wrapWithTableRow === void 0 ? true : _ref$wrapWithTableRow,
      rest = _objectWithoutProperties(_ref, _excluded);

  return (0, _react2.jsx)("thead", _extends({
    className: className
  }, rest), wrapWithTableRow ? (0, _react2.jsx)("tr", null, children) : children);
};

exports.EuiTableHeader = EuiTableHeader;
EuiTableHeader.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,

  /**
       * Children must be valid DOM structure residing within `<thead>`.
       * Use `<td> | <th>` by default, or `<tr><th/></tr>` when `wrapWithTableRow=false`
       */
  children: _propTypes.default.node,

  /**
       * Automatically adds a wrapping `<tr>` element around the children
       */
  wrapWithTableRow: _propTypes.default.bool
};