"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTourStyles = exports.euiTourHeaderStyles = exports.euiTourFooterStyles = exports.euiTourBeaconStyles = void 0;

var _react = require("@emotion/react");

var _services = require("../../services");

var _global_styling = require("../../global_styling");

var _popover_panel = require("../popover/popover_panel/_popover_panel.styles");

var _popover_arrow = require("../popover/popover_arrow/_popover_arrow.styles");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var backgroundColor = function backgroundColor(color, colorMode) {
  return colorMode === _services.COLOR_MODES_STANDARD.dark ? (0, _services.shade)(color, 0.45) : (0, _services.tint)(color, 0.5);
};

var euiTourStyles = function euiTourStyles(_ref) {
  var euiTheme = _ref.euiTheme,
      colorMode = _ref.colorMode;
  return {
    // Targets EuiPopoverPanel
    euiTour: /*#__PURE__*/(0, _react.css)("&[data-popover-open='true']{[class*='euiTourBeacon']{opacity:1;}}[data-popover-arrow='top']{&:before{", (0, _global_styling.logicalCSS)('border-top-color', backgroundColor(euiTheme.colors.lightestShade, colorMode)), ";}};label:euiTour;")
  };
};

exports.euiTourStyles = euiTourStyles;

var euiTourBeaconStyles = function euiTourBeaconStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  var arrowSize = euiTheme.size[_popover_arrow.popoverArrowSize];
  var arrowSizeInt = parseInt(arrowSize, 10);
  return {
    // Base
    euiTourBeacon: /*#__PURE__*/(0, _react.css)("pointer-events:none;position:absolute;opacity:0;transition:opacity 0s ", euiTheme.animation[_popover_panel.openAnimationTiming], ";;label:euiTourBeacon;"),
    // Positions
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', "".concat(arrowSizeInt / 2, "px")), ";", (0, _global_styling.logicalCSS)('left', "".concat(arrowSizeInt * -2, "px")), ";;label:right;"),
    left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', "".concat(arrowSizeInt / 2, "px")), ";", (0, _global_styling.logicalCSS)('left', arrowSize), ";;label:left;"),
    top: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', arrowSize), ";", (0, _global_styling.logicalCSS)('left', "".concat(arrowSizeInt / 2, "px")), ";;label:top;"),
    bottom: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('top', "".concat(arrowSizeInt * -2, "px")), ";", (0, _global_styling.logicalCSS)('left', "".concat(arrowSizeInt / 2, "px")), ";;label:bottom;")
  };
};

exports.euiTourBeaconStyles = euiTourBeaconStyles;

var euiTourHeaderStyles = function euiTourHeaderStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    // Base
    euiTourHeader: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-bottom', 'none'), ";", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:euiTourHeader;"),
    // Elements
    euiTourHeader__title: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-top', 0), ";;label:euiTourHeader__title;"),
    euiTourHeader__subtitle: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.subduedText, ";;label:euiTourHeader__subtitle;")
  };
};

exports.euiTourHeaderStyles = euiTourHeaderStyles;

var euiTourFooterStyles = function euiTourFooterStyles(_ref4) {
  var euiTheme = _ref4.euiTheme,
      colorMode = _ref4.colorMode;
  return {
    // Base
    euiTourFooter: /*#__PURE__*/(0, _react.css)("background-color:", backgroundColor(euiTheme.colors.lightestShade, colorMode), ";", (0, _global_styling.logicalCSS)('border-bottom-left-radius', euiTheme.border.radius.medium), ";", (0, _global_styling.logicalCSS)('border-bottom-right-radius', euiTheme.border.radius.medium), ";;label:euiTourFooter;")
  };
};

exports.euiTourFooterStyles = euiTourFooterStyles;