"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCurrentEuiBreakpoint = void 0;

var _react = require("react");

var _current_breakpoint = require("./current_breakpoint");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Hook util / syntactical sugar for useContext()
 *
 * This hook is in its own separate file to make mocking it
 * as a testenv easy for Jest unit tests
 */
var useCurrentEuiBreakpoint = function useCurrentEuiBreakpoint() {
  var currentBreakpoint = (0, _react.useContext)(_current_breakpoint.CurrentEuiBreakpointContext);
  return currentBreakpoint;
};

exports.useCurrentEuiBreakpoint = useCurrentEuiBreakpoint;