"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShadowColor = void 0;

var _chromaJs = _interopRequireDefault(require("chroma-js"));

var _types = require("../../../../services/theme/types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Create a CSS color value using whose opacity is determined based
// on either a light or dark theme. We use a multiplier
// of 1 for light themes and 2.5 for dark themes
var getShadowColor = function getShadowColor(color, opacity, colorMode) {
  var themeOpacity = colorMode === _types.COLOR_MODES_STANDARD.dark ? opacity * 3.5 : opacity * 1;
  return (0, _chromaJs.default)(color).alpha(themeOpacity).css();
};

exports.getShadowColor = getShadowColor;