"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiButtonColorCSS = exports.euiButtonColor = exports.BUTTON_COLORS = void 0;

var _react = require("@emotion/react");

var _services = require("../../../../services");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var BUTTON_COLORS = ['text', 'accent', 'primary', 'success', 'warning', 'danger', 'disabled'];
exports.BUTTON_COLORS = BUTTON_COLORS;

var euiButtonColor = function euiButtonColor(color, _ref) {
  var euiTheme = _ref.euiTheme,
      colorMode = _ref.colorMode;

  function tintOrShade(color) {
    return colorMode === 'DARK' ? (0, _services.shade)(color, 0.7) : (0, _services.tint)(color, 0.8);
  }

  switch (color) {
    case 'disabled':
      return (0, _services.transparentize)(euiTheme.colors.lightShade, 0.15);

    case 'text':
      return colorMode === 'DARK' ? (0, _services.shade)(euiTheme.colors.lightShade, 0.2) : (0, _services.tint)(euiTheme.colors.lightShade, 0.5);

    default:
      return tintOrShade(euiTheme.colors[color]);
  }
};

exports.euiButtonColor = euiButtonColor;

var useEuiButtonColorCSS = function useEuiButtonColorCSS() {
  var euiTheme = (0, _services.useEuiTheme)();
  return {
    text: /*#__PURE__*/(0, _react.css)("background-color:", euiButtonColor('text', euiTheme), ";;label:text;"),
    accent: /*#__PURE__*/(0, _react.css)("background-color:", euiButtonColor('accent', euiTheme), ";;label:accent;"),
    primary: /*#__PURE__*/(0, _react.css)("background-color:", euiButtonColor('primary', euiTheme), ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("background-color:", euiButtonColor('success', euiTheme), ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("background-color:", euiButtonColor('warning', euiTheme), ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("background-color:", euiButtonColor('danger', euiTheme), ";;label:danger;"),
    disabled: /*#__PURE__*/(0, _react.css)("background-color:", euiButtonColor('disabled', euiTheme), ";;label:disabled;")
  };
};

exports.useEuiButtonColorCSS = useEuiButtonColorCSS;