import _createForOfIteratorHelper from "@babel/runtime/helpers/createForOfIteratorHelper";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function containsGzip(s) {
  return s.split(',').map(function (d) {
    return d.trim();
  }).includes('gzip');
}
/**
 * Returns whether request headers accept a response using gzip compression.
 *
 * @param headers - Request headers.
 * @returns boolean
 */


export function acceptCompression(headers) {
  var compressed = false;
  Object.keys(headers).forEach(function (key) {
    if (key.toLocaleLowerCase() === 'accept-encoding') {
      var acceptEncoding = headers[key];

      if (typeof acceptEncoding === 'string') {
        compressed = containsGzip(acceptEncoding);
      } else if (Array.isArray(acceptEncoding)) {
        var _iterator = _createForOfIteratorHelper(acceptEncoding),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var ae = _step.value;

            if (containsGzip(ae)) {
              compressed = true;
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    }
  });
  return compressed;
}