import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _awaitAsyncGenerator from "@babel/runtime/helpers/awaitAsyncGenerator";
import _wrapAsyncGenerator from "@babel/runtime/helpers/wrapAsyncGenerator";
import _regeneratorRuntime from "@babel/runtime/regenerator";

/**
 * Uses `fetch` and `getReader` to receive an API call as a stream with multiple chunks
 * as soon as they are available. `fetchStream` is implemented as a generator that will
 * yield/emit chunks and can be consumed for example like this:
 *
 * ```js
 * for await (const [error, chunk] of fetchStream(...) {
 *     ...
 * }
 * ```
 *
 * @param endpoint     — The API endpoint including the Kibana basepath.
 * @param abortCtrl    — Abort controller for cancelling the request.
 * @param body         — The request body. For now all requests are POST.
 * @param ndjson       — Boolean flag to receive the stream as a raw string or NDJSON.
 * @param bufferBounce — A buffer timeout which defaults to 100ms. This collects stream
 *                       chunks for the time of the timeout and only then yields/emits them.
 *                       This is useful so we are more in control of passing on data to
 *                       consuming React components and we won't hammer the DOM with
 *                       updates on every received chunk.
 *
 * @returns            - Yields/emits items in the format [error, value]
 *                       inspired by node's recommended error convention for callbacks.
 */
export function fetchStream(_x, _x2, _x3) {
  return _fetchStream.apply(this, arguments);
}

function _fetchStream() {
  _fetchStream = _wrapAsyncGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(endpoint, abortCtrl, body) {
    var ndjson,
        bufferBounce,
        stream,
        _args3 = arguments;
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            ndjson = _args3.length > 3 && _args3[3] !== undefined ? _args3[3] : true;
            bufferBounce = _args3.length > 4 && _args3[4] !== undefined ? _args3[4] : 100;
            _context3.prev = 2;
            _context3.next = 5;
            return _awaitAsyncGenerator(fetch(endpoint, _objectSpread({
              signal: abortCtrl.current.signal,
              method: 'POST',
              headers: {
                // This refers to the format of the request body,
                // not the response, which will be a uint8array Buffer.
                'Content-Type': 'application/json',
                'kbn-xsrf': 'stream'
              }
            }, Object.keys(body).length > 0 ? {
              body: JSON.stringify(body)
            } : {})));

          case 5:
            stream = _context3.sent;
            _context3.next = 13;
            break;

          case 8:
            _context3.prev = 8;
            _context3.t0 = _context3["catch"](2);
            _context3.next = 12;
            return [_context3.t0.toString(), undefined];

          case 12:
            return _context3.abrupt("return");

          case 13:
            if (stream.ok) {
              _context3.next = 17;
              break;
            }

            _context3.next = 16;
            return ["Error ".concat(stream.status, ": ").concat(stream.statusText), undefined];

          case 16:
            return _context3.abrupt("return");

          case 17:
            if (!(stream.body !== null)) {
              _context3.next = 19;
              break;
            }

            return _context3.delegateYield( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
              var reader, partial, actionBuffer, lastCall, _ret;

              return _regeneratorRuntime.wrap(function _callee2$(_context2) {
                while (1) {
                  switch (_context2.prev = _context2.next) {
                    case 0:
                      // Note that Firefox 99 doesn't support `TextDecoderStream` yet.
                      // That's why we skip it here and use `TextDecoder` later to decode each chunk.
                      // Once Firefox supports it, we can use the following alternative:
                      // const reader = stream.body.pipeThrough(new TextDecoderStream()).getReader();
                      reader = stream.body.getReader();
                      partial = '';
                      actionBuffer = [];
                      lastCall = 0;

                    case 4:
                      if (!true) {
                        _context2.next = 20;
                        break;
                      }

                      _context2.prev = 5;
                      return _context2.delegateYield( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
                        var _actionBuffer;

                        var _yield$_awaitAsyncGen, uint8array, done, value, full, parts, last, actions, now;

                        return _regeneratorRuntime.wrap(function _callee$(_context) {
                          while (1) {
                            switch (_context.prev = _context.next) {
                              case 0:
                                _context.next = 2;
                                return _awaitAsyncGenerator(reader.read());

                              case 2:
                                _yield$_awaitAsyncGen = _context.sent;
                                uint8array = _yield$_awaitAsyncGen.value;
                                done = _yield$_awaitAsyncGen.done;

                                if (!done) {
                                  _context.next = 7;
                                  break;
                                }

                                return _context.abrupt("return", "break");

                              case 7:
                                value = new TextDecoder().decode(uint8array);
                                full = "".concat(partial).concat(value);
                                parts = ndjson ? full.split('\n') : [full];
                                last = ndjson ? parts.pop() : '';
                                partial = last !== null && last !== void 0 ? last : '';
                                actions = ndjson ? parts.map(function (p) {
                                  return JSON.parse(p);
                                }) : parts;

                                (_actionBuffer = actionBuffer).push.apply(_actionBuffer, _toConsumableArray(actions));

                                now = Date.now();

                                if (!(now - lastCall >= bufferBounce && actionBuffer.length > 0)) {
                                  _context.next = 22;
                                  break;
                                }

                                _context.next = 18;
                                return [null, actionBuffer];

                              case 18:
                                actionBuffer = [];
                                lastCall = now; // In cases where the next chunk takes longer to be received than the `bufferBounce` timeout,
                                // we trigger this client side timeout to clear a potential intermediate buffer state.
                                // Since `yield` cannot be passed on to other scopes like callbacks,
                                // this pattern using a Promise is used to wait for the timeout.

                                _context.next = 22;
                                return new Promise(function (resolve) {
                                  setTimeout(function () {
                                    if (actionBuffer.length > 0) {
                                      resolve([null, actionBuffer]);
                                      actionBuffer = [];
                                      lastCall = now;
                                    } else {
                                      resolve([null, []]);
                                    }
                                  }, bufferBounce + 10);
                                });

                              case 22:
                              case "end":
                                return _context.stop();
                            }
                          }
                        }, _callee);
                      })(), "t0", 7);

                    case 7:
                      _ret = _context2.t0;

                      if (!(_ret === "break")) {
                        _context2.next = 10;
                        break;
                      }

                      return _context2.abrupt("break", 20);

                    case 10:
                      _context2.next = 18;
                      break;

                    case 12:
                      _context2.prev = 12;
                      _context2.t1 = _context2["catch"](5);

                      if (!(_context2.t1.name !== 'AbortError')) {
                        _context2.next = 17;
                        break;
                      }

                      _context2.next = 17;
                      return [_context2.t1.toString(), undefined];

                    case 17:
                      return _context2.abrupt("break", 20);

                    case 18:
                      _context2.next = 4;
                      break;

                    case 20:
                      if (!(actionBuffer.length > 0)) {
                        _context2.next = 24;
                        break;
                      }

                      _context2.next = 23;
                      return [null, actionBuffer];

                    case 23:
                      actionBuffer.length = 0;

                    case 24:
                    case "end":
                      return _context2.stop();
                  }
                }
              }, _callee2, null, [[5, 12]]);
            })(), "t1", 19);

          case 19:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, null, [[2, 8]]);
  }));
  return _fetchStream.apply(this, arguments);
}