"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyticsClientMock = void 0;

var _rxjs = require("rxjs");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function createMockedAnalyticsClient() {
  return {
    optIn: jest.fn(),
    reportEvent: jest.fn(),
    registerEventType: jest.fn(),
    registerContextProvider: jest.fn(),
    removeContextProvider: jest.fn(),
    registerShipper: jest.fn(),
    telemetryCounter$: new _rxjs.Subject(),
    shutdown: jest.fn()
  };
}

const analyticsClientMock = {
  create: createMockedAnalyticsClient
};
exports.analyticsClientMock = analyticsClientMock;