/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** The options to build the URL of the V3 API. */

/**
 * Builds the URL for the V3 API.
 * @param urlOptions The options to build the URL of the V3 API.
 */
export function buildUrl(urlOptions) {
  var sendTo = urlOptions.sendTo,
      channelName = urlOptions.channelName;
  var baseUrl = sendTo === 'production' ? 'https://telemetry.elastic.co' : 'https://telemetry-staging.elastic.co';
  return "".concat(baseUrl, "/v3/send/").concat(channelName);
}