"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reversePalette = exports.distributeEqually = void 0;

var _palettes = require("../../../../palettes");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Distribute equally
 * @internal
 */
const distributeEqually = (colorRanges, rangeType, continuity, dataBounds) => {
  const items = colorRanges.length;
  const lastIndex = colorRanges.length - 1;
  const {
    min,
    max
  } = (0, _palettes.getDataMinMax)(rangeType, dataBounds);
  const step = (0, _palettes.roundValue)((max - min) / items);

  const getValueForIndex = index => (0, _palettes.roundValue)(min + step * index);

  const getStartValue = index => {
    if (index === 0) {
      return (0, _palettes.checkIsMinContinuity)(continuity) ? Number.NEGATIVE_INFINITY : (0, _palettes.roundValue)(min);
    }

    return getValueForIndex(index);
  };

  const getEndValue = index => {
    if (index === lastIndex) {
      return (0, _palettes.checkIsMaxContinuity)(continuity) ? Number.POSITIVE_INFINITY : (0, _palettes.roundValue)(max);
    }

    return getValueForIndex(index + 1);
  };

  return colorRanges.map((colorRange, index) => ({
    color: colorRange.color,
    start: getStartValue(index),
    end: getEndValue(index)
  }));
};
/**
 * Reverse Palette
 * @internal
 */


exports.distributeEqually = distributeEqually;

const reversePalette = colorRanges => colorRanges.map(({
  color
}, i) => ({
  color,
  start: colorRanges[colorRanges.length - i - 1].start,
  end: colorRanges[colorRanges.length - i - 1].end
})).reverse();

exports.reversePalette = reversePalette;