import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["stops"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { DEFAULT_COLOR_STEPS, DEFAULT_PALETTE_NAME, DEFAULT_MAX_STOP, DEFAULT_MIN_STOP } from './constants';
/** @internal **/

export function calculateStop(stopValue, newMin, oldMin, oldInterval, newInterval) {
  if (oldInterval === 0) {
    return newInterval + newMin;
  }

  return roundValue(newMin + (stopValue - oldMin) * newInterval / oldInterval);
}
/**
 * This is a generic function to compute stops from the current parameters.
 */

export function getPaletteStops(palettes, activePaletteParams, // used to customize color resolution
_ref) {
  var prevPalette = _ref.prevPalette,
      dataBounds = _ref.dataBounds,
      mapFromMinValue = _ref.mapFromMinValue,
      defaultPaletteName = _ref.defaultPaletteName;

  var _getOverallMinMax = getOverallMinMax(activePaletteParams, dataBounds),
      minValue = _getOverallMinMax.min,
      maxValue = _getOverallMinMax.max;

  var interval = maxValue - minValue;

  var _ref2 = activePaletteParams || {},
      currentStops = _ref2.stops,
      otherParams = _objectWithoutProperties(_ref2, _excluded);

  if (activePaletteParams.name === 'custom' && activePaletteParams !== null && activePaletteParams !== void 0 && activePaletteParams.colorStops) {
    // need to generate the palette from the existing controlStops
    return shiftPalette(activePaletteParams.colorStops, maxValue);
  }

  var steps = (activePaletteParams === null || activePaletteParams === void 0 ? void 0 : activePaletteParams.steps) || DEFAULT_COLOR_STEPS; // generate a palette from predefined ones and customize the domain

  var colorStopsFromPredefined = palettes.get(prevPalette || (activePaletteParams === null || activePaletteParams === void 0 ? void 0 : activePaletteParams.name) || defaultPaletteName || DEFAULT_PALETTE_NAME).getCategoricalColors(steps, otherParams);
  var newStopsMin = mapFromMinValue || interval === 0 ? minValue : interval / steps;
  return remapStopsByNewInterval(colorStopsFromPredefined.map(function (color, index) {
    return {
      color: color,
      stop: index
    };
  }), {
    newInterval: interval,
    oldInterval: colorStopsFromPredefined.length,
    newMin: newStopsMin,
    oldMin: 0
  });
} // Utility to remap color stops within new domain

export function remapStopsByNewInterval(controlStops, _ref3) {
  var newInterval = _ref3.newInterval,
      oldInterval = _ref3.oldInterval,
      newMin = _ref3.newMin,
      oldMin = _ref3.oldMin;
  return (controlStops || []).map(function (_ref4) {
    var color = _ref4.color,
        stop = _ref4.stop;
    return {
      color: color,
      stop: calculateStop(stop, newMin, oldMin, oldInterval, newInterval)
    };
  });
} // Need to shift the Custom palette in order to correctly visualize it when in display mode

export function shiftPalette(stops, max) {
  // shift everything right and add an additional stop at the end
  var result = stops.map(function (entry, i, array) {
    return _objectSpread(_objectSpread({}, entry), {}, {
      stop: i + 1 < array.length ? array[i + 1].stop : max
    });
  });

  if (stops[stops.length - 1].stop === max) {
    // extends the range by a fair amount to make it work the extra case for the last stop === max
    var computedStep = getStepValue(stops, result, max) || 1; // do not go beyond the unit step in this case

    var step = Math.min(1, computedStep);
    result[stops.length - 1].stop = max + step;
  }

  return result;
}

function getOverallMinMax(params, dataBounds) {
  var _params$colorStops$0$, _params$colorStops, _params$colorStops$, _params$colorStops$st, _params$colorStops2, _params$colorStops3;

  var _getDataMinMax = getDataMinMax(params === null || params === void 0 ? void 0 : params.rangeType, dataBounds),
      dataMin = _getDataMinMax.min,
      dataMax = _getDataMinMax.max;

  var minStopValue = (_params$colorStops$0$ = params === null || params === void 0 ? void 0 : (_params$colorStops = params.colorStops) === null || _params$colorStops === void 0 ? void 0 : (_params$colorStops$ = _params$colorStops[0]) === null || _params$colorStops$ === void 0 ? void 0 : _params$colorStops$.stop) !== null && _params$colorStops$0$ !== void 0 ? _params$colorStops$0$ : Number.POSITIVE_INFINITY;
  var maxStopValue = (_params$colorStops$st = params === null || params === void 0 ? void 0 : (_params$colorStops2 = params.colorStops) === null || _params$colorStops2 === void 0 ? void 0 : (_params$colorStops3 = _params$colorStops2[params.colorStops.length - 1]) === null || _params$colorStops3 === void 0 ? void 0 : _params$colorStops3.stop) !== null && _params$colorStops$st !== void 0 ? _params$colorStops$st : Number.NEGATIVE_INFINITY;
  var overallMin = Math.min(dataMin, minStopValue);
  var overallMax = Math.max(dataMax, maxStopValue);
  return {
    min: overallMin,
    max: overallMax
  };
}

export function roundValue(value) {
  var fractionDigits = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  return Number((Math.floor(value * 100) / 100).toFixed(fractionDigits));
} // very simple heuristic: pick last two stops and compute a new stop based on the same distance
// if the new stop is above max, then reduce the step to reach max, or if zero then just 1.
//
// it accepts two series of stops as the function is used also when computing stops from colorStops

export function getStepValue(colorStops, newColorStops, max) {
  var length = newColorStops.length; // workout the steps from the last 2 items

  var dataStep = length > 1 ? newColorStops[length - 1].stop - newColorStops[length - 2].stop || 1 : 1;
  var step = Number(dataStep.toFixed(2));

  if (max < colorStops[length - 1].stop + step) {
    var diffToMax = max - colorStops[length - 1].stop; // if the computed step goes way out of bound, fallback to 1, otherwise reach max

    step = diffToMax > 0 ? diffToMax : 1;
  }

  return step;
}
export function getDataMinMax(rangeType, dataBounds) {
  var dataMin = rangeType === 'number' ? dataBounds.min : DEFAULT_MIN_STOP;
  var dataMax = rangeType === 'number' ? dataBounds.max : DEFAULT_MAX_STOP;
  return {
    min: dataMin,
    max: dataMax
  };
}
export var checkIsMinContinuity = function checkIsMinContinuity(continuity) {
  return Boolean(continuity && ['below', 'all'].includes(continuity));
};
export var checkIsMaxContinuity = function checkIsMaxContinuity(continuity) {
  return Boolean(continuity && ['above', 'all'].includes(continuity));
};
export var getFallbackDataBounds = function getFallbackDataBounds() {
  var rangeType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'percent';
  return rangeType === 'percent' ? {
    min: 0,
    max: 100,
    fallback: true
  } : {
    min: 1,
    max: 1,
    fallback: true
  };
};
export function reversePalette() {
  var paletteColorRepresentation = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var stops = paletteColorRepresentation.map(function (_ref5) {
    var stop = _ref5.stop;
    return stop;
  });
  return paletteColorRepresentation.map(function (_ref6, i) {
    var color = _ref6.color;
    return {
      color: color,
      stop: stops[paletteColorRepresentation.length - i - 1]
    };
  }).reverse();
}