import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _regeneratorRuntime from "@babel/runtime/regenerator";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var getMockedPalette = function getMockedPalette(id, title, colors) {
  var canDynamicColoring = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
  var counter = 0;
  return {
    id: id,
    title: title,
    getCategoricalColor: function getCategoricalColor(_) {
      counter++;
      if (counter > colors.length - 1) counter = 0;
      return colors[counter];
    },
    canDynamicColoring: canDynamicColoring,
    internal: true,
    getCategoricalColors: function getCategoricalColors(num) {
      return colors;
    },
    toExpression: function toExpression() {
      return {
        type: 'expression',
        chain: [{
          type: 'function',
          "function": 'system_palette',
          arguments: {
            name: ['default']
          }
        }]
      };
    }
  };
};

export var getPaletteRegistry = function getPaletteRegistry() {
  var getMockedPalettes = function getMockedPalettes() {
    return {
      "default": getMockedPalette('default', 'Default Palette', ['#54B399', '#6092C0', '#D36086', '#9170B8', '#CA8EAE', '#D6BF57', '#B9A888', '#DA8B45', '#AA6556', '#E7664C']),
      positive: getMockedPalette('positive', 'Grey Palette', ['#222', '#333', '#444', '#555', '#666', '#777', '#888', '#999', '#AAA', '#BBB']),
      foo: getMockedPalette('foo', 'Foo Palette', ['#7E7', '#7D7', '#7A7', '#797', '#787', '#777', '#767', '#757', '#747', '#737']),
      custom: getMockedPalette('custom', 'Custom Palette', [], false)
    };
  };

  return {
    get: function get(name) {
      return getMockedPalettes()[name];
    },
    getAll: function getAll() {
      return Object.values(getMockedPalettes());
    }
  };
};
export var palettes = {
  getPalettes: function () {
    var _getPalettes = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              return _context.abrupt("return", getPaletteRegistry());

            case 1:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    function getPalettes() {
      return _getPalettes.apply(this, arguments);
    }

    return getPalettes;
  }()
};