import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useState, useEffect } from 'react';
import { camelCase } from 'lodash';
import { EuiFlexGroup, EuiTextColor, EuiFlexItem } from '@elastic/eui';
import { DEFAULT_CONTINUITY, DEFAULT_RANGE_TYPE } from '../../../palettes';
import { ColorRangesExtraActions } from './color_ranges_extra_actions';
import { ColorRangeItem } from './color_ranges_item';
import { validateColorRanges, getErrorMessages } from './color_ranges_validation';
import { jsx as ___EmotionJSX } from "@emotion/react";
export function ColorRanges(_ref) {
  var _paletteConfiguration, _paletteConfiguration2;

  var colorRanges = _ref.colorRanges,
      paletteConfiguration = _ref.paletteConfiguration,
      showExtraActions = _ref.showExtraActions,
      dispatch = _ref.dispatch;

  var _useState = useState({}),
      _useState2 = _slicedToArray(_useState, 2),
      colorRangesValidity = _useState2[0],
      setColorRangesValidity = _useState2[1];

  var lastColorRange = colorRanges[colorRanges.length - 1];
  var errors = getErrorMessages(colorRangesValidity);
  var continuity = (_paletteConfiguration = paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.continuity) !== null && _paletteConfiguration !== void 0 ? _paletteConfiguration : DEFAULT_CONTINUITY;
  var rangeType = (_paletteConfiguration2 = paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.rangeType) !== null && _paletteConfiguration2 !== void 0 ? _paletteConfiguration2 : DEFAULT_RANGE_TYPE;
  useEffect(function () {
    setColorRangesValidity(validateColorRanges(colorRanges, rangeType === 'percent'));
  }, [colorRanges, rangeType]);
  return ___EmotionJSX(EuiFlexGroup, {
    "data-test-subj": "lnsPalettePanel_dynamicColoring_custom_color_ranges",
    direction: "column",
    gutterSize: "s"
  }, colorRanges.map(function (colorRange, index) {
    var _ref2, _colorRange$end;

    return ___EmotionJSX(EuiFlexItem, {
      grow: false,
      key: "".concat((_ref2 = (_colorRange$end = colorRange.end) !== null && _colorRange$end !== void 0 ? _colorRange$end : 0 + colorRange.start) !== null && _ref2 !== void 0 ? _ref2 : 0).concat(index)
    }, ___EmotionJSX(ColorRangeItem, {
      colorRange: colorRange,
      dispatch: dispatch,
      colorRanges: colorRanges,
      continuity: continuity,
      rangeType: rangeType,
      index: index,
      validation: colorRangesValidity[index],
      accessor: "start"
    }));
  }), lastColorRange ? ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(ColorRangeItem, {
    colorRange: lastColorRange,
    dispatch: dispatch,
    colorRanges: colorRanges,
    continuity: continuity,
    rangeType: rangeType,
    index: colorRanges.length - 1,
    validation: colorRangesValidity.last,
    accessor: "end"
  })) : null, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, errors.map(function (error) {
    return ___EmotionJSX(EuiTextColor, {
      color: "danger",
      key: "".concat(camelCase(error))
    }, error);
  })), showExtraActions ? ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(ColorRangesExtraActions, {
    dispatch: dispatch,
    shouldDisableAdd: Boolean((paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.maxSteps) && colorRanges.length >= (paletteConfiguration === null || paletteConfiguration === void 0 ? void 0 : paletteConfiguration.maxSteps) || errors.length),
    shouldDisableDistribute: Boolean(colorRanges.length === 1),
    shouldDisableReverse: Boolean(colorRanges.length === 1)
  })) : null);
}