import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { i18n } from '@kbn/i18n';
import useUpdateEffect from 'react-use/lib/useUpdateEffect';
import React, { useState, useCallback, useContext, useMemo } from 'react';
import { css } from '@emotion/react';
import { EuiFieldNumber, EuiColorPicker, EuiFlexItem, EuiFlexGroup, EuiIcon, EuiColorPickerSwatch, EuiButtonIcon, useEuiTheme } from '@elastic/eui';
import { checkIsMaxContinuity, checkIsMinContinuity } from '../../../palettes';
import { RelatedIcon } from '../assets/related';
import { getAutoBoundInformation, isLastItem } from './utils';
import { isValidColor } from '../utils';
import { ColorRangeDeleteButton, ColorRangeAutoDetectButton, ColorRangeEditButton } from './color_ranges_item_buttons';
import { ColorRangesContext } from './color_ranges_context';
import { jsx as ___EmotionJSX } from "@emotion/react";

var getMode = function getMode(index, isLast, continuity) {
  if (!isLast && index > 0) {
    return 'value';
  }

  return (isLast ? checkIsMaxContinuity : checkIsMinContinuity)(continuity) ? 'auto' : 'edit';
};

var getActionButton = function getActionButton(mode) {
  if (mode === 'value') {
    return ColorRangeDeleteButton;
  }

  return mode === 'edit' ? ColorRangeAutoDetectButton : ColorRangeEditButton;
};

var getAppend = function getAppend(rangeType, mode) {
  var items = [];

  if (rangeType === 'percent') {
    items.push('%');
  }

  return items;
};

export function ColorRangeItem(_ref) {
  var _validation$isValid;

  var accessor = _ref.accessor,
      index = _ref.index,
      colorRange = _ref.colorRange,
      rangeType = _ref.rangeType,
      colorRanges = _ref.colorRanges,
      validation = _ref.validation,
      continuity = _ref.continuity,
      dispatch = _ref.dispatch;

  var _useContext = useContext(ColorRangesContext),
      dataBounds = _useContext.dataBounds,
      palettes = _useContext.palettes;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      popoverInFocus = _useState2[0],
      setPopoverInFocus = _useState2[1];

  var _useState3 = useState(colorRange[accessor]),
      _useState4 = _slicedToArray(_useState3, 2),
      localValue = _useState4[0],
      setLocalValue = _useState4[1];

  var isLast = isLastItem(accessor);
  var mode = getMode(index, isLast, continuity);
  var isDisabled = mode === 'auto';
  var isColorValid = isValidColor(colorRange.color);
  var ActionButton = getActionButton(mode);
  var isValid = (_validation$isValid = validation === null || validation === void 0 ? void 0 : validation.isValid) !== null && _validation$isValid !== void 0 ? _validation$isValid : true;

  var _useEuiTheme = useEuiTheme(),
      euiTheme = _useEuiTheme.euiTheme;

  var onLeaveFocus = useCallback(function (e) {
    var _colorRanges$start, _colorRanges, _colorRanges$start2, _colorRanges2, _colorRanges$end, _colorRanges3, _e$currentTarget;

    var prevStartValue = (_colorRanges$start = (_colorRanges = colorRanges[index - 1]) === null || _colorRanges === void 0 ? void 0 : _colorRanges.start) !== null && _colorRanges$start !== void 0 ? _colorRanges$start : Number.NEGATIVE_INFINITY;
    var nextStartValue = (_colorRanges$start2 = (_colorRanges2 = colorRanges[index + 1]) === null || _colorRanges2 === void 0 ? void 0 : _colorRanges2.start) !== null && _colorRanges$start2 !== void 0 ? _colorRanges$start2 : Number.POSITIVE_INFINITY;
    var lastEndValue = (_colorRanges$end = (_colorRanges3 = colorRanges[colorRanges.length - 1]) === null || _colorRanges3 === void 0 ? void 0 : _colorRanges3.end) !== null && _colorRanges$end !== void 0 ? _colorRanges$end : Number.POSITIVE_INFINITY;
    var shouldSort = colorRange.start > nextStartValue || prevStartValue > colorRange.start || !isLast && colorRange.start > lastEndValue;
    var isFocusStillInContent = ((_e$currentTarget = e.currentTarget) === null || _e$currentTarget === void 0 ? void 0 : _e$currentTarget.contains(e.relatedTarget)) || popoverInFocus;

    if (shouldSort && !isFocusStillInContent) {
      dispatch({
        type: 'sortColorRanges',
        payload: {
          dataBounds: dataBounds,
          palettes: palettes
        }
      });
    }
  }, [colorRange.start, colorRanges, dispatch, index, popoverInFocus, dataBounds, palettes, isLast]);
  var onValueChange = useCallback(function (_ref2) {
    var targetValue = _ref2.target.value;
    setLocalValue(targetValue);
    dispatch({
      type: 'updateValue',
      payload: {
        index: index,
        value: targetValue,
        accessor: accessor,
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [dispatch, index, accessor, dataBounds, palettes]);
  var onUpdateColor = useCallback(function (color) {
    dispatch({
      type: 'updateColor',
      payload: {
        index: index,
        color: color,
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [dispatch, index, dataBounds, palettes]);
  useUpdateEffect(function () {
    if (!Number.isNaN(colorRange[accessor]) && colorRange[accessor] !== localValue) {
      setLocalValue(colorRange[accessor]);
    }
  }, [localValue, colorRange, accessor]);
  var selectNewColorText = i18n.translate('coloring.dynamicColoring.customPalette.selectNewColor', {
    defaultMessage: 'Select a new color'
  });
  var styles = useMemo(function () {
    return /*#__PURE__*/css("display:block;min-width:", euiTheme.size.xl, ";text-align:center;" + (process.env.NODE_ENV === "production" ? "" : ";label:color_ranges_item--styles;"), process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
  }, [euiTheme.size.xl]);
  var autoBoundInfo = getAutoBoundInformation({
    isPercentage: rangeType === 'percent',
    isUpper: isLast,
    isAuto: mode === 'auto'
  });
  return ___EmotionJSX(EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false,
    css: isLast ? styles : null
  }, !isLast ? ___EmotionJSX(EuiColorPicker, {
    onChange: onUpdateColor,
    button: isColorValid ? ___EmotionJSX(EuiColorPickerSwatch, {
      color: colorRange.color,
      "aria-label": selectNewColorText,
      style: {
        width: euiTheme.size.xl,
        height: euiTheme.size.xl
      }
    }) : ___EmotionJSX(EuiButtonIcon, {
      color: "danger",
      iconType: "stopSlash",
      iconSize: "l",
      "aria-label": selectNewColorText
    }),
    secondaryInputDisplay: "top",
    color: colorRange.color,
    showAlpha: true,
    onFocus: function onFocus() {
      return setPopoverInFocus(true);
    },
    onBlur: function onBlur() {
      setPopoverInFocus(false);
    },
    isInvalid: !isColorValid
  }) : ___EmotionJSX(EuiIcon, {
    type: RelatedIcon,
    size: "m",
    color: euiTheme.colors.disabled
  })), ___EmotionJSX(EuiFlexItem, {
    grow: true
  }, ___EmotionJSX(EuiFieldNumber, {
    compressed: true,
    fullWidth: true,
    isInvalid: !isValid,
    value: mode !== 'auto' && localValue !== undefined && isFinite(localValue) ? localValue : '',
    disabled: isDisabled,
    onChange: onValueChange,
    placeholder: mode === 'auto' ? autoBoundInfo.representation : '',
    append: getAppend(rangeType, mode),
    onBlur: onLeaveFocus,
    "data-test-subj": "lnsPalettePanel_dynamicColoring_range_value_".concat(index),
    prepend: ___EmotionJSX("span", {
      className: "euiFormLabel"
    }, isLast ? "\u2264" : "\u2265"),
    "aria-label": i18n.translate('coloring.dynamicColoring.customPalette.rangeAriaLabel', {
      defaultMessage: 'Range {index}',
      values: {
        index: index + 1
      }
    }),
    step: "any"
  })), ActionButton ? ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, ___EmotionJSX(ActionButton, {
    index: index,
    continuity: continuity,
    rangeType: rangeType,
    colorRanges: colorRanges,
    dispatch: dispatch,
    tooltipContent: autoBoundInfo.actionDescription,
    iconFactory: autoBoundInfo.icon,
    accessor: accessor
  })) : null);
}