import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { roundValue, getDataMinMax } from '../../../../palettes';

/**
 * Allows to update a ColorRange
 * @private
 */
var updateColorRangeItem = function updateColorRangeItem(colorRanges, index, payload) {
  var ranges = _toConsumableArray(colorRanges);

  ranges[index] = _objectSpread(_objectSpread({}, ranges[index]), payload);
  return ranges;
};
/**
 * Add new color range after the last item
 * @internal
 */


export var addColorRange = function addColorRange(colorRanges, rangeType, dataBounds) {
  var newColorRanges = _toConsumableArray(colorRanges);

  var lastIndex = newColorRanges.length - 1;
  var lastStart = newColorRanges[lastIndex].start;
  var lastEnd = newColorRanges[lastIndex].end;
  var lastColor = newColorRanges[lastIndex].color;

  var _getDataMinMax = getDataMinMax(rangeType, dataBounds),
      dataMax = _getDataMinMax.max;

  var max = Math.max(dataMax, lastEnd);
  var insertEnd = roundValue(Math.min(lastStart + 1, max));

  if (insertEnd === Number.NEGATIVE_INFINITY) {
    insertEnd = 1;
  }

  newColorRanges = updateColorRangeItem(newColorRanges, lastIndex, {
    end: insertEnd
  });
  newColorRanges.push({
    color: lastColor,
    start: insertEnd,
    end: lastEnd === insertEnd ? lastEnd + 1 : lastEnd
  });
  return newColorRanges;
};
/**
 * Delete ColorRange
 * @internal
 */

export var deleteColorRange = function deleteColorRange(index, colorRanges) {
  var lastIndex = colorRanges.length - 1;
  var ranges = colorRanges;

  if (index !== 0) {
    if (index !== lastIndex) {
      ranges = updateColorRangeItem(ranges, index - 1, {
        end: ranges[index + 1].start
      });
    }

    if (index === lastIndex) {
      ranges = updateColorRangeItem(ranges, index - 1, {
        end: colorRanges[index].end
      });
    }
  }

  return ranges.filter(function (item, i) {
    return i !== index;
  });
};
/**
 * Update ColorRange value
 * @internal
 */

export var updateColorRangeValue = function updateColorRangeValue(index, value, accessor, colorRanges) {
  var parsedValue = value ? parseFloat(value) : Number.NaN;
  var ranges = colorRanges;

  if (accessor === 'end') {
    ranges = updateColorRangeItem(ranges, index, {
      end: parsedValue
    });
  } else {
    ranges = updateColorRangeItem(ranges, index, {
      start: parsedValue
    });

    if (index > 0) {
      ranges = updateColorRangeItem(ranges, index - 1, {
        end: parsedValue
      });
    }
  }

  return ranges;
};
/**
 * Update ColorRange color
 * @internal
 */

export var updateColorRangeColor = function updateColorRangeColor(index, color, colorRanges) {
  return updateColorRangeItem(colorRanges, index, {
    color: color
  });
};