/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { checkIsMaxContinuity, checkIsMinContinuity, roundValue, getDataMinMax } from '../../../../palettes';

/**
 * Distribute equally
 * @internal
 */
export var distributeEqually = function distributeEqually(colorRanges, rangeType, continuity, dataBounds) {
  var items = colorRanges.length;
  var lastIndex = colorRanges.length - 1;

  var _getDataMinMax = getDataMinMax(rangeType, dataBounds),
      min = _getDataMinMax.min,
      max = _getDataMinMax.max;

  var step = roundValue((max - min) / items);

  var getValueForIndex = function getValueForIndex(index) {
    return roundValue(min + step * index);
  };

  var getStartValue = function getStartValue(index) {
    if (index === 0) {
      return checkIsMinContinuity(continuity) ? Number.NEGATIVE_INFINITY : roundValue(min);
    }

    return getValueForIndex(index);
  };

  var getEndValue = function getEndValue(index) {
    if (index === lastIndex) {
      return checkIsMaxContinuity(continuity) ? Number.POSITIVE_INFINITY : roundValue(max);
    }

    return getValueForIndex(index + 1);
  };

  return colorRanges.map(function (colorRange, index) {
    return {
      color: colorRange.color,
      start: getStartValue(index),
      end: getEndValue(index)
    };
  });
};
/**
 * Reverse Palette
 * @internal
 */

export var reversePalette = function reversePalette(colorRanges) {
  return colorRanges.map(function (_ref, i) {
    var color = _ref.color;
    return {
      color: color,
      start: colorRanges[colorRanges.length - i - 1].start,
      end: colorRanges[colorRanges.length - i - 1].end
    };
  }).reverse();
};