import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { i18n } from '@kbn/i18n';
import React, { useReducer, useMemo } from 'react';
import useDebounce from 'react-use/lib/useDebounce';
import { css } from '@emotion/react';
import { EuiFormRow, htmlIdGenerator, EuiButtonGroup, EuiIconTip, useEuiTheme } from '@elastic/eui';
import { PalettePicker } from './palette_picker';
import { getFallbackDataBounds } from '../../palettes';
import { toColorRanges } from './utils';
import { ColorRanges, ColorRangesContext } from './color_ranges';
import { allRangesValid } from './color_ranges/color_ranges_validation';
import { paletteConfigurationReducer } from './palette_configuration_reducer';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var CustomizablePalette = function CustomizablePalette(_ref) {
  var _activePalette$params, _activePalette$params2, _localState$activePal2, _localState$activePal3, _localState$activePal4;

  var palettes = _ref.palettes,
      activePalette = _ref.activePalette,
      setPalette = _ref.setPalette,
      _ref$dataBounds = _ref.dataBounds,
      dataBounds = _ref$dataBounds === void 0 ? getFallbackDataBounds((_activePalette$params = activePalette.params) === null || _activePalette$params === void 0 ? void 0 : _activePalette$params.rangeType) : _ref$dataBounds,
      _ref$showExtraActions = _ref.showExtraActions,
      showExtraActions = _ref$showExtraActions === void 0 ? true : _ref$showExtraActions,
      _ref$showRangeTypeSel = _ref.showRangeTypeSelector,
      showRangeTypeSelector = _ref$showRangeTypeSel === void 0 ? true : _ref$showRangeTypeSel,
      _ref$disableSwitching = _ref.disableSwitchingContinuity,
      disableSwitchingContinuity = _ref$disableSwitching === void 0 ? false : _ref$disableSwitching;
  var idPrefix = useMemo(function () {
    return htmlIdGenerator()();
  }, []);
  var colorRangesToShow = toColorRanges(palettes, ((_activePalette$params2 = activePalette.params) === null || _activePalette$params2 === void 0 ? void 0 : _activePalette$params2.colorStops) || [], activePalette, dataBounds);

  var _useReducer = useReducer(paletteConfigurationReducer, {
    activePalette: activePalette,
    colorRanges: colorRangesToShow
  }),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      localState = _useReducer2[0],
      dispatch = _useReducer2[1];

  useDebounce(function () {
    var _localState$activePal;

    if ((localState.activePalette !== activePalette || colorRangesToShow !== localState.colorRanges) && allRangesValid(localState.colorRanges, ((_localState$activePal = localState.activePalette.params) === null || _localState$activePal === void 0 ? void 0 : _localState$activePal.rangeType) === 'percent')) {
      setPalette(localState.activePalette);
    }
  }, 250, [localState]);

  var _useEuiTheme = useEuiTheme(),
      euiTheme = _useEuiTheme.euiTheme;

  var styles = useMemo(function () {
    return /*#__PURE__*/css("padding:", euiTheme.size.base, ";" + (process.env.NODE_ENV === "production" ? "" : ";label:palette_configuration--styles;"), process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
  }, [euiTheme.size.base]);
  return ___EmotionJSX("div", {
    css: styles,
    className: "lnsPalettePanel__section"
  }, ___EmotionJSX(EuiFormRow, {
    display: "rowCompressed",
    label: i18n.translate('coloring.dynamicColoring.palettePicker.label', {
      defaultMessage: 'Color palette'
    }),
    fullWidth: true
  }, ___EmotionJSX(PalettePicker, {
    "data-test-subj": "lnsPalettePanel_dynamicColoring_palette_picker",
    palettes: palettes,
    activePalette: localState.activePalette,
    setPalette: function setPalette(newPalette) {
      var isPaletteChanged = newPalette.name !== activePalette.name;

      if (isPaletteChanged) {
        dispatch({
          type: 'changeColorPalette',
          payload: {
            palette: newPalette,
            dataBounds: dataBounds,
            palettes: palettes,
            disableSwitchingContinuity: disableSwitchingContinuity
          }
        });
      }
    },
    showCustomPalette: true,
    showDynamicColorOnly: true
  })), showRangeTypeSelector && ___EmotionJSX(EuiFormRow, {
    fullWidth: true,
    label: ___EmotionJSX(React.Fragment, null, i18n.translate('coloring.dynamicColoring.rangeType.label', {
      defaultMessage: 'Value type'
    }), ' ', ___EmotionJSX(EuiIconTip, {
      content: i18n.translate('coloring.dynamicColoring.customPalette.colorStopsHelpPercentage', {
        defaultMessage: 'Percent value types are relative to the full range of available data values.'
      }),
      position: "top",
      size: "s"
    })),
    display: "rowCompressed"
  }, ___EmotionJSX(EuiButtonGroup, {
    isFullWidth: true,
    legend: i18n.translate('coloring.dynamicColoring.rangeType.label', {
      defaultMessage: 'Value type'
    }),
    "data-test-subj": "lnsPalettePanel_dynamicColoring_custom_range_groups",
    name: "dynamicColoringRangeType",
    buttonSize: "compressed",
    options: [{
      id: "".concat(idPrefix, "percent"),
      label: i18n.translate('coloring.dynamicColoring.rangeType.percent', {
        defaultMessage: 'Percent'
      }),
      'data-test-subj': 'lnsPalettePanel_dynamicColoring_rangeType_groups_percent'
    }, {
      id: "".concat(idPrefix, "number"),
      label: i18n.translate('coloring.dynamicColoring.rangeType.number', {
        defaultMessage: 'Number'
      }),
      'data-test-subj': 'lnsPalettePanel_dynamicColoring_rangeType_groups_number'
    }],
    idSelected: (_localState$activePal2 = localState.activePalette.params) !== null && _localState$activePal2 !== void 0 && _localState$activePal2.rangeType ? "".concat(idPrefix).concat((_localState$activePal3 = localState.activePalette.params) === null || _localState$activePal3 === void 0 ? void 0 : _localState$activePal3.rangeType) : "".concat(idPrefix, "percent"),
    onChange: function onChange(id) {
      var newRangeType = id.replace(idPrefix, '');
      dispatch({
        type: 'updateRangeType',
        payload: {
          rangeType: newRangeType,
          dataBounds: dataBounds,
          palettes: palettes
        }
      });
    }
  })), ___EmotionJSX(EuiFormRow, {
    label: i18n.translate('coloring.dynamicColoring.palettePicker.colorRangesLabel', {
      defaultMessage: 'Color Ranges'
    }),
    display: "rowCompressed",
    fullWidth: true
  }, ___EmotionJSX(ColorRangesContext.Provider, {
    value: {
      dataBounds: dataBounds,
      palettes: palettes,
      disableSwitchingContinuity: disableSwitchingContinuity
    }
  }, ___EmotionJSX(ColorRanges, {
    showExtraActions: showExtraActions,
    paletteConfiguration: (_localState$activePal4 = localState.activePalette) === null || _localState$activePal4 === void 0 ? void 0 : _localState$activePal4.params,
    colorRanges: localState.colorRanges,
    dispatch: dispatch
  }))));
};