"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObjectToConfigAdapter = void 0;

var _lodash = require("lodash");

var _saferLodashSet = require("@kbn/safer-lodash-set");

var _std = require("@kbn/std");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Allows plain javascript object to behave like `RawConfig` instance.
 * @internal
 */
class ObjectToConfigAdapter {
  constructor(rawConfig) {
    this.rawConfig = rawConfig;
  }

  has(configPath) {
    return (0, _lodash.has)(this.rawConfig, configPath);
  }

  get(configPath) {
    return (0, _lodash.get)(this.rawConfig, configPath);
  }

  set(configPath, value) {
    (0, _saferLodashSet.set)(this.rawConfig, configPath, value);
  }

  getFlattenedPaths() {
    return Object.keys((0, _std.getFlattenedObject)(this.rawConfig));
  }

  toRaw() {
    return (0, _lodash.cloneDeep)(this.rawConfig);
  }

}

exports.ObjectToConfigAdapter = ObjectToConfigAdapter;