"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForIndexStatus = waitForIndexStatus;

var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));

var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");

var _constants = require("./constants");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Wait until an index status become either 'yellow' or 'green'.
 *
 * A yellow index status means the index's primary shard was allocated but ES
 * wasn't able to allocate the replica. Thus a yellow index can be searched
 * and read from but indexing documents with `wait_for_active_shards='all'`
 * will fail.
 *
 * A green index status means the index's primary and replica shards has been
 * allocated so we can search, read and index documents with
 * `wait_for_active_shards='all'`.
 */
function waitForIndexStatus({
  client,
  index,
  timeout = _constants.DEFAULT_TIMEOUT,
  status
}) {
  return () => {
    return client.cluster.health({
      index,
      wait_for_status: status,
      timeout
    }, {
      /* Don't reject on status code 408 so that we can handle the timeout
       * explicitly with a custom response type and provide more context in the error message
       */
      ignore: [408]
    }).then(res => {
      if (res.timed_out === true) {
        return Either.left({
          type: `index_not_${status}_timeout`,
          message: `[index_not_${status}_timeout] Timeout waiting for the status of the [${index}] index to become '${status}'`
        });
      }

      return Either.right({});
    }).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
  };
}