/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { deepFreeze } from '@kbn/std';
import { getDocLinksMeta } from './get_doc_meta';
export var getDocLinks = function getDocLinks(_ref) {
  var kibanaBranch = _ref.kibanaBranch;
  var meta = getDocLinksMeta({
    kibanaBranch: kibanaBranch
  });
  var DOC_LINK_VERSION = meta.version;
  var ELASTIC_WEBSITE_URL = meta.elasticWebsiteUrl;
  var DOCS_WEBSITE_URL = meta.docsWebsiteUrl;
  var ELASTICSEARCH_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/reference/").concat(DOC_LINK_VERSION, "/");
  var KIBANA_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/kibana/").concat(DOC_LINK_VERSION, "/");
  var FLEET_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/fleet/").concat(DOC_LINK_VERSION, "/");
  var PLUGIN_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/plugins/").concat(DOC_LINK_VERSION, "/");
  var APM_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/apm/");
  var SECURITY_SOLUTION_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/security/").concat(DOC_LINK_VERSION, "/");
  var APP_SEARCH_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/app-search/").concat(DOC_LINK_VERSION, "/");
  var ENTERPRISE_SEARCH_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/enterprise-search/").concat(DOC_LINK_VERSION, "/");
  var WORKPLACE_SEARCH_DOCS = "".concat(ELASTIC_WEBSITE_URL, "guide/en/workplace-search/").concat(DOC_LINK_VERSION, "/");
  var SEARCH_UI_DOCS = "".concat(DOCS_WEBSITE_URL, "search-ui/");
  return deepFreeze({
    settings: "".concat(ELASTIC_WEBSITE_URL, "guide/en/kibana/").concat(DOC_LINK_VERSION, "/settings.html"),
    elasticStackGetStarted: "".concat(ELASTIC_WEBSITE_URL, "guide/en/index.html"),
    upgrade: {
      upgradingStackOnPrem: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elastic-stack/8.0/upgrading-elastic-stack-on-prem.html"),
      upgradingStackOnCloud: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elastic-stack/8.0/upgrade-elastic-stack-for-elastic-cloud.html")
    },
    apm: {
      kibanaSettings: "".concat(KIBANA_DOCS, "apm-settings-in-kibana.html"),
      supportedServiceMaps: "".concat(KIBANA_DOCS, "service-maps.html#service-maps-supported"),
      customLinks: "".concat(KIBANA_DOCS, "custom-links.html"),
      droppedTransactionSpans: "".concat(APM_DOCS, "guide/").concat(DOC_LINK_VERSION, "/data-model-spans.html#data-model-dropped-spans"),
      upgrading: "".concat(APM_DOCS, "guide/").concat(DOC_LINK_VERSION, "/upgrade.html"),
      metaData: "".concat(APM_DOCS, "guide/").concat(DOC_LINK_VERSION, "/data-model-metadata.html"),
      overview: "".concat(APM_DOCS, "guide/").concat(DOC_LINK_VERSION, "/apm-overview.html"),
      tailSamplingPolicies: "".concat(APM_DOCS, "guide/").concat(DOC_LINK_VERSION, "/configure-tail-based-sampling.html"),
      elasticAgent: "".concat(APM_DOCS, "guide/").concat(DOC_LINK_VERSION, "/upgrade-to-apm-integration.html")
    },
    canvas: {
      guide: "".concat(KIBANA_DOCS, "canvas.html")
    },
    cloud: {
      indexManagement: "".concat(ELASTIC_WEBSITE_URL, "guide/en/cloud/current/ec-configure-index-management.html")
    },
    console: {
      guide: "".concat(KIBANA_DOCS, "console-kibana.html")
    },
    dashboard: {
      guide: "".concat(KIBANA_DOCS, "dashboard.html"),
      drilldowns: "".concat(KIBANA_DOCS, "drilldowns.html"),
      drilldownsTriggerPicker: "".concat(KIBANA_DOCS, "create-drilldowns.html#url-drilldowns"),
      urlDrilldownTemplateSyntax: "".concat(KIBANA_DOCS, "create-drilldowns.html#url_templating-language"),
      urlDrilldownVariables: "".concat(KIBANA_DOCS, "create-drilldowns.html#url-template-variables")
    },
    discover: {
      guide: "".concat(KIBANA_DOCS, "discover.html"),
      fieldStatistics: "".concat(KIBANA_DOCS, "show-field-statistics.html"),
      fieldTypeHelp: "".concat(ELASTICSEARCH_DOCS, "mapping-types.html"),
      dateFieldTypeDocs: "".concat(ELASTICSEARCH_DOCS, "date.html"),
      dateFormatsDocs: "".concat(ELASTICSEARCH_DOCS, "mapping-date-format.html"),
      documentExplorer: "".concat(KIBANA_DOCS, "document-explorer.html")
    },
    filebeat: {
      base: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION),
      installation: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION, "/filebeat-installation-configuration.html"),
      configuration: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION, "/configuring-howto-filebeat.html"),
      elasticsearchModule: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION, "/filebeat-module-elasticsearch.html"),
      elasticsearchOutput: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION, "/elasticsearch-output.html"),
      startup: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION, "/filebeat-starting.html"),
      exportedFields: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION, "/exported-fields.html"),
      suricataModule: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION, "/filebeat-module-suricata.html"),
      zeekModule: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/filebeat/").concat(DOC_LINK_VERSION, "/filebeat-module-zeek.html")
    },
    auditbeat: {
      base: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/auditbeat/").concat(DOC_LINK_VERSION),
      auditdModule: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/auditbeat/").concat(DOC_LINK_VERSION, "/auditbeat-module-auditd.html"),
      systemModule: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/auditbeat/").concat(DOC_LINK_VERSION, "/auditbeat-module-system.html")
    },
    appSearch: {
      adaptiveRelevance: "".concat(APP_SEARCH_DOCS, "curations-guide.html#curations-reference-adaptive-relevance"),
      apiRef: "".concat(APP_SEARCH_DOCS, "api-reference.html"),
      apiClients: "".concat(APP_SEARCH_DOCS, "api-clients.html"),
      apiKeys: "".concat(APP_SEARCH_DOCS, "authentication.html#authentication-api-keys"),
      authentication: "".concat(APP_SEARCH_DOCS, "authentication.html"),
      crawlRules: "".concat(APP_SEARCH_DOCS, "crawl-web-content.html#crawl-web-content-manage-crawl-rules"),
      curations: "".concat(APP_SEARCH_DOCS, "curations-guide.html"),
      duplicateDocuments: "".concat(APP_SEARCH_DOCS, "web-crawler-reference.html#web-crawler-reference-content-deduplication"),
      elasticsearchIndexedEngines: "".concat(APP_SEARCH_DOCS, "elasticsearch-engines.html"),
      entryPoints: "".concat(APP_SEARCH_DOCS, "crawl-web-content.html#crawl-web-content-manage-entry-points"),
      gettingStarted: "".concat(APP_SEARCH_DOCS, "getting-started.html"),
      guide: "".concat(APP_SEARCH_DOCS, "index.html"),
      indexingDocuments: "".concat(APP_SEARCH_DOCS, "indexing-documents-guide.html"),
      indexingDocumentsSchema: "".concat(APP_SEARCH_DOCS, "indexing-documents-guide.html#indexing-documents-guide-schema"),
      logSettings: "".concat(APP_SEARCH_DOCS, "logs.html"),
      metaEngines: "".concat(APP_SEARCH_DOCS, "meta-engines-guide.html"),
      precisionTuning: "".concat(APP_SEARCH_DOCS, "precision-tuning.html"),
      relevanceTuning: "".concat(APP_SEARCH_DOCS, "relevance-tuning-guide.html"),
      resultSettings: "".concat(APP_SEARCH_DOCS, "result-settings-guide.html"),
      searchUI: "".concat(APP_SEARCH_DOCS, "reference-ui-guide.html"),
      security: "".concat(APP_SEARCH_DOCS, "security-and-users.html"),
      synonyms: "".concat(APP_SEARCH_DOCS, "synonyms-guide.html"),
      webCrawler: "".concat(APP_SEARCH_DOCS, "web-crawler.html"),
      webCrawlerEventLogs: "".concat(APP_SEARCH_DOCS, "view-web-crawler-events-logs.html"),
      webCrawlerReference: "".concat(APP_SEARCH_DOCS, "web-crawler-reference.html")
    },
    enterpriseSearch: {
      apiKeys: "".concat(KIBANA_DOCS, "api-keys.html"),
      bulkApi: "".concat(ELASTICSEARCH_DOCS, "docs-bulk.html"),
      configuration: "".concat(ENTERPRISE_SEARCH_DOCS, "configuration.html"),
      connectors: "".concat(ENTERPRISE_SEARCH_DOCS, "connectors.html"),
      connectorsMongoDB: "".concat(ENTERPRISE_SEARCH_DOCS, "connectors-mongodb.html"),
      connectorsMySQL: "".concat(ENTERPRISE_SEARCH_DOCS, "connectors-mysql.html"),
      connectorsWorkplaceSearch: "".concat(ENTERPRISE_SEARCH_DOCS, "connectors.html#connectors-workplace-search"),
      crawlerManaging: "".concat(ENTERPRISE_SEARCH_DOCS, "crawler-managing.html"),
      crawlerOverview: "".concat(ENTERPRISE_SEARCH_DOCS, "crawler.html"),
      deployTrainedModels: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-nlp-deploy-models.html"),
      documentLevelSecurity: "".concat(ELASTICSEARCH_DOCS, "document-level-security.html"),
      ingestPipelines: "".concat(ENTERPRISE_SEARCH_DOCS, "ingest-pipelines.html"),
      languageAnalyzers: "".concat(ELASTICSEARCH_DOCS, "analysis-lang-analyzer.html"),
      languageClients: "".concat(ENTERPRISE_SEARCH_DOCS, "programming-language-clients.html"),
      licenseManagement: "".concat(ENTERPRISE_SEARCH_DOCS, "license-management.html"),
      mailService: "".concat(ENTERPRISE_SEARCH_DOCS, "mailer-configuration.html"),
      start: "".concat(ENTERPRISE_SEARCH_DOCS, "start.html"),
      troubleshootSetup: "".concat(ENTERPRISE_SEARCH_DOCS, "troubleshoot-setup.html"),
      usersAccess: "".concat(ENTERPRISE_SEARCH_DOCS, "users-access.html")
    },
    workplaceSearch: {
      apiKeys: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-api-authentication.html"),
      box: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-box-connector.html"),
      confluenceCloud: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-confluence-cloud-connector.html"),
      confluenceCloudConnectorPackage: "".concat(WORKPLACE_SEARCH_DOCS, "confluence-cloud.html"),
      confluenceServer: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-confluence-server-connector.html"),
      contentSources: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-content-sources.html"),
      customConnectorPackage: "".concat(WORKPLACE_SEARCH_DOCS, "custom-connector-package.html"),
      customSources: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-custom-api-sources.html"),
      customSourcePermissions: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-custom-api-sources.html#custom-api-source-document-level-access-control"),
      documentPermissions: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-sources-document-permissions.html"),
      dropbox: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-dropbox-connector.html"),
      externalSharePointOnline: "".concat(WORKPLACE_SEARCH_DOCS, "sharepoint-online-external.html"),
      externalIdentities: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-external-identities-api.html"),
      gettingStarted: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-getting-started.html"),
      gitHub: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-github-connector.html"),
      gmail: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-gmail-connector.html"),
      googleDrive: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-google-drive-connector.html"),
      indexingSchedule: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-customizing-indexing-rules.html#_indexing_schedule"),
      jiraCloud: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-jira-cloud-connector.html"),
      jiraServer: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-jira-server-connector.html"),
      networkDrive: "".concat(WORKPLACE_SEARCH_DOCS, "network-drives.html"),
      oneDrive: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-onedrive-connector.html"),
      permissions: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-permissions.html"),
      privateSourcePermissions: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-permissions.html#organizational-sources-private-sources"),
      salesforce: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-salesforce-connector.html"),
      security: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-security.html"),
      serviceNow: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-servicenow-connector.html"),
      sharePoint: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-sharepoint-online-connector.html"),
      sharePointServer: "".concat(WORKPLACE_SEARCH_DOCS, "sharepoint-server.html"),
      slack: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-slack-connector.html"),
      synch: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-customizing-indexing-rules.html"),
      zendesk: "".concat(WORKPLACE_SEARCH_DOCS, "workplace-search-zendesk-connector.html")
    },
    metricbeat: {
      base: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/metricbeat/").concat(DOC_LINK_VERSION),
      configure: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/metricbeat/").concat(DOC_LINK_VERSION, "/configuring-howto-metricbeat.html"),
      httpEndpoint: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/metricbeat/").concat(DOC_LINK_VERSION, "/http-endpoint.html"),
      install: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/metricbeat/").concat(DOC_LINK_VERSION, "/metricbeat-installation-configuration.html"),
      start: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/metricbeat/").concat(DOC_LINK_VERSION, "/metricbeat-starting.html")
    },
    heartbeat: {
      base: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/heartbeat/").concat(DOC_LINK_VERSION)
    },
    libbeat: {
      getStarted: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/libbeat/").concat(DOC_LINK_VERSION, "/getting-started.html")
    },
    logstash: {
      base: "".concat(ELASTIC_WEBSITE_URL, "guide/en/logstash/").concat(DOC_LINK_VERSION),
      inputElasticAgent: "".concat(ELASTIC_WEBSITE_URL, "guide/en/logstash/").concat(DOC_LINK_VERSION, "/plugins-inputs-elastic_agent.html")
    },
    functionbeat: {
      base: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/functionbeat/").concat(DOC_LINK_VERSION)
    },
    winlogbeat: {
      base: "".concat(ELASTIC_WEBSITE_URL, "guide/en/beats/winlogbeat/").concat(DOC_LINK_VERSION)
    },
    aggs: {
      composite: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-composite-aggregation.html"),
      composite_missing_bucket: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-composite-aggregation.html#_missing_bucket"),
      date_histogram: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-datehistogram-aggregation.html"),
      date_range: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-daterange-aggregation.html"),
      date_format_pattern: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-daterange-aggregation.html#date-format-pattern"),
      filter: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-filter-aggregation.html"),
      filters: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-filters-aggregation.html"),
      geohash_grid: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-geohashgrid-aggregation.html"),
      histogram: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-histogram-aggregation.html"),
      ip_range: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-iprange-aggregation.html"),
      range: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-range-aggregation.html"),
      significant_terms: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-significantterms-aggregation.html"),
      terms: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-terms-aggregation.html"),
      terms_doc_count_error: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-terms-aggregation.html#_per_bucket_document_count_error"),
      rare_terms: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-bucket-rare-terms-aggregation.html"),
      avg: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-avg-aggregation.html"),
      avg_bucket: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-pipeline-avg-bucket-aggregation.html"),
      max_bucket: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-pipeline-max-bucket-aggregation.html"),
      min_bucket: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-pipeline-min-bucket-aggregation.html"),
      sum_bucket: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-pipeline-sum-bucket-aggregation.html"),
      cardinality: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-cardinality-aggregation.html"),
      count: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-valuecount-aggregation.html"),
      cumulative_sum: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-sum-aggregation.html"),
      derivative: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-pipeline-derivative-aggregation.html"),
      geo_bounds: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-geobounds-aggregation.html"),
      geo_centroid: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-geocentroid-aggregation.html"),
      max: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-max-aggregation.html"),
      median: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-percentile-aggregation.html"),
      min: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-min-aggregation.html"),
      moving_avg: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-pipeline-movfn-aggregation.html"),
      percentile_ranks: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-percentile-rank-aggregation.html"),
      serial_diff: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-pipeline-serialdiff-aggregation.html"),
      std_dev: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-extendedstats-aggregation.html"),
      sum: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-sum-aggregation.html"),
      top_hits: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-top-hits-aggregation.html"),
      top_metrics: "".concat(ELASTICSEARCH_DOCS, "search-aggregations-metrics-top-metrics.html")
    },
    runtimeFields: {
      overview: "".concat(ELASTICSEARCH_DOCS, "runtime.html"),
      mapping: "".concat(ELASTICSEARCH_DOCS, "runtime-mapping-fields.html")
    },
    scriptedFields: {
      scriptFields: "".concat(ELASTICSEARCH_DOCS, "search-request-script-fields.html"),
      scriptAggs: "".concat(ELASTICSEARCH_DOCS, "search-aggregations.html"),
      painless: "".concat(ELASTICSEARCH_DOCS, "modules-scripting-painless.html"),
      painlessApi: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/painless/").concat(DOC_LINK_VERSION, "/painless-api-reference.html"),
      painlessLangSpec: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/painless/").concat(DOC_LINK_VERSION, "/painless-lang-spec.html"),
      painlessSyntax: "".concat(ELASTICSEARCH_DOCS, "modules-scripting-painless-syntax.html"),
      painlessWalkthrough: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/painless/").concat(DOC_LINK_VERSION, "/painless-walkthrough.html"),
      painlessLanguage: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/painless/").concat(DOC_LINK_VERSION, "/painless-lang-spec.html"),
      luceneExpressions: "".concat(ELASTICSEARCH_DOCS, "modules-scripting-expression.html")
    },
    indexPatterns: {
      introduction: "".concat(KIBANA_DOCS, "data-views.html"),
      fieldFormattersNumber: "".concat(KIBANA_DOCS, "numeral.html"),
      fieldFormattersString: "".concat(KIBANA_DOCS, "managing-data-views.html#string-field-formatters"),
      runtimeFields: "".concat(KIBANA_DOCS, "managing-data-views.html#runtime-fields")
    },
    addData: "".concat(KIBANA_DOCS, "connect-to-elasticsearch.html"),
    kibana: {
      guide: "".concat(KIBANA_DOCS, "index.html"),
      autocompleteSuggestions: "".concat(KIBANA_DOCS, "kibana-concepts-analysts.html#autocomplete-suggestions"),
      secureSavedObject: "".concat(KIBANA_DOCS, "xpack-security-secure-saved-objects.html"),
      xpackSecurity: "".concat(KIBANA_DOCS, "xpack-security.html")
    },
    upgradeAssistant: {
      overview: "".concat(KIBANA_DOCS, "upgrade-assistant.html"),
      batchReindex: "".concat(KIBANA_DOCS, "batch-start-resume-reindex.html"),
      remoteReindex: "".concat(ELASTICSEARCH_DOCS, "docs-reindex.html#reindex-from-remote")
    },
    rollupJobs: "".concat(KIBANA_DOCS, "data-rollups.html"),
    elasticsearch: {
      docsBase: "".concat(ELASTICSEARCH_DOCS),
      asyncSearch: "".concat(ELASTICSEARCH_DOCS, "async-search-intro.html"),
      dataStreams: "".concat(ELASTICSEARCH_DOCS, "data-streams.html"),
      deprecationLogging: "".concat(ELASTICSEARCH_DOCS, "logging.html#deprecation-logging"),
      createIndex: "".concat(ELASTICSEARCH_DOCS, "indices-create-index.html"),
      frozenIndices: "".concat(ELASTICSEARCH_DOCS, "frozen-indices.html"),
      gettingStarted: "".concat(ELASTICSEARCH_DOCS, "getting-started.html"),
      hiddenIndices: "".concat(ELASTICSEARCH_DOCS, "multi-index.html#hidden"),
      ilm: "".concat(ELASTICSEARCH_DOCS, "index-lifecycle-management.html"),
      ilmForceMerge: "".concat(ELASTICSEARCH_DOCS, "ilm-forcemerge.html"),
      ilmFreeze: "".concat(ELASTICSEARCH_DOCS, "ilm-freeze.html"),
      ilmPhaseTransitions: "".concat(ELASTICSEARCH_DOCS, "ilm-index-lifecycle.html#ilm-phase-transitions"),
      ilmReadOnly: "".concat(ELASTICSEARCH_DOCS, "ilm-readonly.html"),
      ilmRollover: "".concat(ELASTICSEARCH_DOCS, "ilm-rollover.html"),
      ilmSearchableSnapshot: "".concat(ELASTICSEARCH_DOCS, "ilm-searchable-snapshot.html"),
      ilmSetPriority: "".concat(ELASTICSEARCH_DOCS, "ilm-set-priority.html"),
      ilmShrink: "".concat(ELASTICSEARCH_DOCS, "ilm-shrink.html"),
      ilmWaitForSnapshot: "".concat(ELASTICSEARCH_DOCS, "ilm-wait-for-snapshot.html"),
      indexModules: "".concat(ELASTICSEARCH_DOCS, "index-modules.html"),
      indexSettings: "".concat(ELASTICSEARCH_DOCS, "index-modules.html#index-modules-settings"),
      dynamicIndexSettings: "".concat(ELASTICSEARCH_DOCS, "index-modules.html#dynamic-index-settings"),
      indexTemplates: "".concat(ELASTICSEARCH_DOCS, "index-templates.html"),
      mapping: "".concat(ELASTICSEARCH_DOCS, "mapping.html"),
      mappingAnalyzer: "".concat(ELASTICSEARCH_DOCS, "analyzer.html"),
      mappingCoerce: "".concat(ELASTICSEARCH_DOCS, "coerce.html"),
      mappingCopyTo: "".concat(ELASTICSEARCH_DOCS, "copy-to.html"),
      mappingDocValues: "".concat(ELASTICSEARCH_DOCS, "doc-values.html"),
      mappingDynamic: "".concat(ELASTICSEARCH_DOCS, "dynamic.html"),
      mappingDynamicFields: "".concat(ELASTICSEARCH_DOCS, "dynamic-field-mapping.html"),
      mappingDynamicTemplates: "".concat(ELASTICSEARCH_DOCS, "dynamic-templates.html"),
      mappingEagerGlobalOrdinals: "".concat(ELASTICSEARCH_DOCS, "eager-global-ordinals.html"),
      mappingEnabled: "".concat(ELASTICSEARCH_DOCS, "enabled.html"),
      mappingFieldData: "".concat(ELASTICSEARCH_DOCS, "text.html#fielddata-mapping-param"),
      mappingFieldDataEnable: "".concat(ELASTICSEARCH_DOCS, "text.html#before-enabling-fielddata"),
      mappingFieldDataFilter: "".concat(ELASTICSEARCH_DOCS, "text.html#field-data-filtering"),
      mappingFieldDataTypes: "".concat(ELASTICSEARCH_DOCS, "mapping-types.html"),
      mappingFormat: "".concat(ELASTICSEARCH_DOCS, "mapping-date-format.html"),
      mappingIgnoreAbove: "".concat(ELASTICSEARCH_DOCS, "ignore-above.html"),
      mappingIgnoreMalformed: "".concat(ELASTICSEARCH_DOCS, "ignore-malformed.html"),
      mappingIndex: "".concat(ELASTICSEARCH_DOCS, "mapping-index.html"),
      mappingIndexOptions: "".concat(ELASTICSEARCH_DOCS, "index-options.html"),
      mappingIndexPhrases: "".concat(ELASTICSEARCH_DOCS, "index-phrases.html"),
      mappingIndexPrefixes: "".concat(ELASTICSEARCH_DOCS, "index-prefixes.html"),
      mappingJoinFieldsPerformance: "".concat(ELASTICSEARCH_DOCS, "parent-join.html#_parent_join_and_performance"),
      mappingMeta: "".concat(ELASTICSEARCH_DOCS, "mapping-field-meta.html"),
      mappingMetaFields: "".concat(ELASTICSEARCH_DOCS, "mapping-meta-field.html"),
      mappingMultifields: "".concat(ELASTICSEARCH_DOCS, "multi-fields.html"),
      mappingNormalizer: "".concat(ELASTICSEARCH_DOCS, "normalizer.html"),
      mappingNorms: "".concat(ELASTICSEARCH_DOCS, "norms.html"),
      mappingNullValue: "".concat(ELASTICSEARCH_DOCS, "null-value.html"),
      mappingParameters: "".concat(ELASTICSEARCH_DOCS, "mapping-params.html"),
      mappingPositionIncrementGap: "".concat(ELASTICSEARCH_DOCS, "position-increment-gap.html"),
      mappingRankFeatureFields: "".concat(ELASTICSEARCH_DOCS, "rank-feature.html"),
      mappingRouting: "".concat(ELASTICSEARCH_DOCS, "mapping-routing-field.html"),
      mappingSimilarity: "".concat(ELASTICSEARCH_DOCS, "similarity.html"),
      mappingSourceFields: "".concat(ELASTICSEARCH_DOCS, "mapping-source-field.html"),
      mappingSourceFieldsDisable: "".concat(ELASTICSEARCH_DOCS, "mapping-source-field.html#disable-source-field"),
      mappingStore: "".concat(ELASTICSEARCH_DOCS, "mapping-store.html"),
      mappingTermVector: "".concat(ELASTICSEARCH_DOCS, "term-vector.html"),
      mappingTypesRemoval: "".concat(ELASTICSEARCH_DOCS, "removal-of-types.html"),
      migrateIndexAllocationFilters: "".concat(ELASTICSEARCH_DOCS, "migrate-index-allocation-filters.html"),
      migrationApiDeprecation: "".concat(ELASTICSEARCH_DOCS, "migration-api-deprecation.html"),
      nodeRoles: "".concat(ELASTICSEARCH_DOCS, "modules-node.html#node-roles"),
      releaseHighlights: "".concat(ELASTICSEARCH_DOCS, "release-highlights.html"),
      version8ReleaseHighlights: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elastic-stack/8.0/elastic-stack-highlights.html"),
      remoteClusters: "".concat(ELASTICSEARCH_DOCS, "remote-clusters.html"),
      remoteClustersProxy: "".concat(ELASTICSEARCH_DOCS, "remote-clusters.html#proxy-mode"),
      remoteClusersProxySettings: "".concat(ELASTICSEARCH_DOCS, "remote-clusters-settings.html#remote-cluster-proxy-settings"),
      scriptParameters: "".concat(ELASTICSEARCH_DOCS, "modules-scripting-using.html#prefer-params"),
      secureCluster: "".concat(ELASTICSEARCH_DOCS, "secure-cluster.html"),
      shardAllocationSettings: "".concat(ELASTICSEARCH_DOCS, "modules-cluster.html#cluster-shard-allocation-settings"),
      sortSearch: "".concat(ELASTICSEARCH_DOCS, "sort-search-results.html"),
      transportSettings: "".concat(ELASTICSEARCH_DOCS, "modules-network.html#common-network-settings"),
      typesRemoval: "".concat(ELASTICSEARCH_DOCS, "removal-of-types.html"),
      setupUpgrade: "".concat(ELASTICSEARCH_DOCS, "setup-upgrade.html"),
      apiCompatibilityHeader: "".concat(ELASTICSEARCH_DOCS, "api-conventions.html#api-compatibility")
    },
    siem: {
      guide: "".concat(SECURITY_SOLUTION_DOCS, "index.html"),
      gettingStarted: "".concat(SECURITY_SOLUTION_DOCS, "index.html"),
      privileges: "".concat(SECURITY_SOLUTION_DOCS, "sec-requirements.html"),
      ml: "".concat(SECURITY_SOLUTION_DOCS, "machine-learning.html"),
      ruleChangeLog: "".concat(SECURITY_SOLUTION_DOCS, "prebuilt-rules-changelog.html"),
      detectionsReq: "".concat(SECURITY_SOLUTION_DOCS, "detections-permissions-section.html"),
      networkMap: "".concat(SECURITY_SOLUTION_DOCS, "conf-map-ui.html"),
      troubleshootGaps: "".concat(SECURITY_SOLUTION_DOCS, "alerts-ui-monitor.html#troubleshoot-gaps"),
      ruleApiOverview: "".concat(SECURITY_SOLUTION_DOCS, "rule-api-overview.html")
    },
    securitySolution: {
      trustedApps: "".concat(SECURITY_SOLUTION_DOCS, "trusted-apps-ov.html"),
      eventFilters: "".concat(SECURITY_SOLUTION_DOCS, "event-filters.html"),
      blocklist: "".concat(SECURITY_SOLUTION_DOCS, "blocklist.html"),
      threatIntelInt: "".concat(SECURITY_SOLUTION_DOCS, "es-threat-intel-integrations.html"),
      endpointArtifacts: "".concat(SECURITY_SOLUTION_DOCS, "endpoint-artifacts.html"),
      policyResponseTroubleshooting: {
        full_disk_access: "".concat(SECURITY_SOLUTION_DOCS, "deploy-elastic-endpoint.html#enable-fda-endpoint"),
        macos_system_ext: "".concat(SECURITY_SOLUTION_DOCS, "deploy-elastic-endpoint.html#system-extension-endpoint"),
        linux_deadlock: "".concat(SECURITY_SOLUTION_DOCS, "ts-management.html#linux-deadlock")
      },
      packageActionTroubleshooting: {
        // TODO: Pending to be updated when docs are ready
        es_connection: ''
      },
      responseActions: "".concat(SECURITY_SOLUTION_DOCS, "response-actions.html"),
      exceptions: {
        value_lists: "".concat(SECURITY_SOLUTION_DOCS, "detections-ui-exceptions.html#manage-value-lists")
      }
    },
    query: {
      eql: "".concat(ELASTICSEARCH_DOCS, "eql.html"),
      kueryQuerySyntax: "".concat(KIBANA_DOCS, "kuery-query.html"),
      luceneQuery: "".concat(ELASTICSEARCH_DOCS, "query-dsl-query-string-query.html"),
      luceneQuerySyntax: "".concat(ELASTICSEARCH_DOCS, "query-dsl-query-string-query.html#query-string-syntax"),
      percolate: "".concat(ELASTICSEARCH_DOCS, "query-dsl-percolate-query.html"),
      queryDsl: "".concat(ELASTICSEARCH_DOCS, "query-dsl.html")
    },
    search: {
      sessions: "".concat(KIBANA_DOCS, "search-sessions.html"),
      sessionLimits: "".concat(KIBANA_DOCS, "search-sessions.html#_limitations")
    },
    date: {
      dateMath: "".concat(ELASTICSEARCH_DOCS, "common-options.html#date-math"),
      dateMathIndexNames: "".concat(ELASTICSEARCH_DOCS, "date-math-index-names.html")
    },
    management: {
      dashboardSettings: "".concat(KIBANA_DOCS, "advanced-options.html#kibana-dashboard-settings"),
      indexManagement: "".concat(ELASTICSEARCH_DOCS, "index-mgmt.html"),
      kibanaSearchSettings: "".concat(KIBANA_DOCS, "advanced-options.html#kibana-search-settings"),
      visualizationSettings: "".concat(KIBANA_DOCS, "advanced-options.html#kibana-visualization-settings"),
      timelionSettings: "".concat(KIBANA_DOCS, "advanced-options.html#kibana-timelion-settings"),
      savedObjectsApiList: "".concat(KIBANA_DOCS, "saved-objects-api.html#saved-objects-api")
    },
    ml: {
      guide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/index.html"),
      aggregations: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-configuring-aggregation.html"),
      anomalyDetection: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-overview.html"),
      anomalyDetectionJobs: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-finding-anomalies.html"),
      anomalyDetectionConfiguringCategories: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-configuring-categories.html"),
      anomalyDetectionBucketSpan: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-bucket-span"),
      anomalyDetectionCardinality: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-cardinality"),
      anomalyDetectionCreateJobs: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-create-job"),
      anomalyDetectionDetectors: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-detectors"),
      anomalyDetectionInfluencers: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-influencers"),
      anomalyDetectionJobResource: "".concat(ELASTICSEARCH_DOCS, "ml-put-job.html#ml-put-job-path-parms"),
      anomalyDetectionJobResourceAnalysisConfig: "".concat(ELASTICSEARCH_DOCS, "ml-put-job.html#put-analysisconfig"),
      anomalyDetectionJobTips: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-job-tips"),
      alertingRules: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-configuring-alerts.html"),
      anomalyDetectionModelMemoryLimits: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-model-memory-limits"),
      calendars: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-calendars"),
      classificationEvaluation: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-dfa-classification.html#ml-dfanalytics-classification-evaluation"),
      customRules: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-ad-run-jobs.html#ml-ad-rules"),
      customUrls: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-configuring-url.html"),
      dataFrameAnalytics: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-dfanalytics.html"),
      dFAPrepareData: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-dfa-overview.html#prepare-transform-data"),
      featureImportance: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-feature-importance.html"),
      outlierDetectionRoc: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-dfa-finding-outliers.html#ml-dfanalytics-roc"),
      regressionEvaluation: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-dfa-regression.html#ml-dfanalytics-regression-evaluation"),
      classificationAucRoc: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-dfa-classification.html#ml-dfanalytics-class-aucroc"),
      setUpgradeMode: "".concat(ELASTICSEARCH_DOCS, "ml-set-upgrade-mode.html"),
      trainedModels: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-trained-models.html"),
      startTrainedModelsDeployment: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-nlp-deploy-models.html#ml-nlp-deploy-model")
    },
    transforms: {
      guide: "".concat(ELASTICSEARCH_DOCS, "transforms.html"),
      // TODO add valid docs URL
      alertingRules: "".concat(ELASTIC_WEBSITE_URL, "guide/en/machine-learning/").concat(DOC_LINK_VERSION, "/ml-configuring-alerts.html")
    },
    visualize: {
      guide: "".concat(KIBANA_DOCS, "dashboard.html"),
      lens: "".concat(ELASTIC_WEBSITE_URL, "what-is/kibana-lens"),
      lensPanels: "".concat(KIBANA_DOCS, "lens.html"),
      maps: "".concat(ELASTIC_WEBSITE_URL, "maps"),
      vega: "".concat(KIBANA_DOCS, "vega.html"),
      tsvbIndexPatternMode: "".concat(KIBANA_DOCS, "tsvb.html#tsvb-index-pattern-mode")
    },
    observability: {
      guide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/index.html"),
      infrastructureThreshold: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/infrastructure-threshold-alert.html"),
      logsThreshold: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/logs-threshold-alert.html"),
      metricsThreshold: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/metrics-threshold-alert.html"),
      monitorStatus: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/monitor-status-alert.html"),
      monitorUptime: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/monitor-uptime.html"),
      tlsCertificate: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/tls-certificate-alert.html"),
      uptimeDurationAnomaly: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/duration-anomaly-alert.html"),
      monitorLogs: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/monitor-logs.html"),
      analyzeMetrics: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/analyze-metrics.html"),
      monitorUptimeSynthetics: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/monitor-uptime-synthetics.html"),
      userExperience: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/user-experience.html"),
      createAlerts: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/create-alerts.html"),
      syntheticsCommandReference: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/synthetics-configuration.html#synthetics-configuration-playwright-options"),
      syntheticsProjectMonitors: "".concat(ELASTIC_WEBSITE_URL, "guide/en/observability/").concat(DOC_LINK_VERSION, "/synthetic-run-tests.html#synthetic-monitor-choose-project")
    },
    alerting: {
      guide: "".concat(KIBANA_DOCS, "create-and-manage-rules.html"),
      actionTypes: "".concat(KIBANA_DOCS, "action-types.html"),
      apmRules: "".concat(KIBANA_DOCS, "apm-alerts.html"),
      emailAction: "".concat(KIBANA_DOCS, "email-action-type.html"),
      emailActionConfig: "".concat(KIBANA_DOCS, "email-action-type.html"),
      emailExchangeClientSecretConfig: "".concat(KIBANA_DOCS, "email-action-type.html#exchange-client-secret"),
      emailExchangeClientIdConfig: "".concat(KIBANA_DOCS, "email-action-type.html#exchange-client-tenant-id"),
      generalSettings: "".concat(KIBANA_DOCS, "alert-action-settings-kb.html#general-alert-action-settings"),
      indexAction: "".concat(KIBANA_DOCS, "index-action-type.html"),
      esQuery: "".concat(KIBANA_DOCS, "rule-type-es-query.html"),
      indexThreshold: "".concat(KIBANA_DOCS, "rule-type-index-threshold.html"),
      pagerDutyAction: "".concat(KIBANA_DOCS, "pagerduty-action-type.html"),
      preconfiguredConnectors: "".concat(KIBANA_DOCS, "pre-configured-connectors.html"),
      preconfiguredAlertHistoryConnector: "".concat(KIBANA_DOCS, "index-action-type.html#preconfigured-connector-alert-history"),
      serviceNowAction: "".concat(KIBANA_DOCS, "servicenow-action-type.html#configuring-servicenow"),
      serviceNowSIRAction: "".concat(KIBANA_DOCS, "servicenow-sir-action-type.html"),
      setupPrerequisites: "".concat(KIBANA_DOCS, "alerting-setup.html#alerting-prerequisites"),
      slackAction: "".concat(KIBANA_DOCS, "slack-action-type.html#configuring-slack"),
      teamsAction: "".concat(KIBANA_DOCS, "teams-action-type.html#configuring-teams")
    },
    maps: {
      guide: "".concat(KIBANA_DOCS, "maps.html"),
      importGeospatialPrivileges: "".concat(KIBANA_DOCS, "import-geospatial-data.html#import-geospatial-privileges"),
      gdalTutorial: "".concat(ELASTIC_WEBSITE_URL, "blog/how-to-ingest-geospatial-data-into-elasticsearch-with-gdal"),
      termJoinsExample: "".concat(KIBANA_DOCS, "terms-join.html#_example_term_join")
    },
    monitoring: {
      alertsKibana: "".concat(KIBANA_DOCS, "kibana-alerts.html"),
      alertsKibanaCpuThreshold: "".concat(KIBANA_DOCS, "kibana-alerts.html#kibana-alerts-cpu-threshold"),
      alertsKibanaDiskThreshold: "".concat(KIBANA_DOCS, "kibana-alerts.html#kibana-alerts-disk-usage-threshold"),
      alertsKibanaJvmThreshold: "".concat(KIBANA_DOCS, "kibana-alerts.html#kibana-alerts-jvm-memory-threshold"),
      alertsKibanaMissingData: "".concat(KIBANA_DOCS, "kibana-alerts.html#kibana-alerts-missing-monitoring-data"),
      alertsKibanaThreadpoolRejections: "".concat(KIBANA_DOCS, "kibana-alerts.html#kibana-alerts-thread-pool-rejections"),
      alertsKibanaCCRReadExceptions: "".concat(KIBANA_DOCS, "kibana-alerts.html#kibana-alerts-ccr-read-exceptions"),
      alertsKibanaLargeShardSize: "".concat(KIBANA_DOCS, "kibana-alerts.html#kibana-alerts-large-shard-size"),
      alertsKibanaClusterAlerts: "".concat(KIBANA_DOCS, "kibana-alerts.html#kibana-alerts-cluster-alerts"),
      metricbeatBlog: "".concat(ELASTIC_WEBSITE_URL, "blog/external-collection-for-elastic-stack-monitoring-is-now-available-via-metricbeat"),
      monitorElasticsearch: "".concat(ELASTICSEARCH_DOCS, "configuring-metricbeat.html"),
      monitorKibana: "".concat(KIBANA_DOCS, "monitoring-metricbeat.html"),
      monitorLogstash: "".concat(ELASTIC_WEBSITE_URL, "guide/en/logstash/").concat(DOC_LINK_VERSION, "/monitoring-with-metricbeat.html"),
      troubleshootKibana: "".concat(KIBANA_DOCS, "monitor-troubleshooting.html")
    },
    reporting: {
      cloudMinimumRequirements: "".concat(KIBANA_DOCS, "reporting-getting-started.html#reporting-on-cloud-resource-requirements"),
      grantUserAccess: "".concat(KIBANA_DOCS, "secure-reporting.html#grant-user-access"),
      browserSystemDependencies: "".concat(KIBANA_DOCS, "secure-reporting.html#install-reporting-packages"),
      browserSandboxDependencies: "".concat(KIBANA_DOCS, "reporting-troubleshooting.html#reporting-troubleshooting-sandbox-dependency")
    },
    security: {
      apiKeyServiceSettings: "".concat(ELASTICSEARCH_DOCS, "security-settings.html#api-key-service-settings"),
      clusterPrivileges: "".concat(ELASTICSEARCH_DOCS, "security-privileges.html#privileges-list-cluster"),
      elasticsearchSettings: "".concat(ELASTICSEARCH_DOCS, "security-settings.html"),
      elasticsearchEnableSecurity: "".concat(ELASTICSEARCH_DOCS, "configuring-stack-security.html"),
      elasticsearchEnableApiKeys: "".concat(ELASTICSEARCH_DOCS, "security-settings.html#api-key-service-settings"),
      indicesPrivileges: "".concat(ELASTICSEARCH_DOCS, "security-privileges.html#privileges-list-indices"),
      kibanaTLS: "".concat(ELASTICSEARCH_DOCS, "security-basic-setup.html#encrypt-internode-communication"),
      kibanaPrivileges: "".concat(KIBANA_DOCS, "kibana-privileges.html"),
      mappingRoles: "".concat(ELASTICSEARCH_DOCS, "mapping-roles.html"),
      mappingRolesFieldRules: "".concat(ELASTICSEARCH_DOCS, "role-mapping-resources.html#mapping-roles-rule-field"),
      runAsPrivilege: "".concat(ELASTICSEARCH_DOCS, "security-privileges.html#_run_as_privilege")
    },
    spaces: {
      kibanaLegacyUrlAliases: "".concat(KIBANA_DOCS, "legacy-url-aliases.html"),
      kibanaDisableLegacyUrlAliasesApi: "".concat(KIBANA_DOCS, "spaces-api-disable-legacy-url-aliases.html")
    },
    watcher: {
      jiraAction: "".concat(ELASTICSEARCH_DOCS, "actions-jira.html"),
      pagerDutyAction: "".concat(ELASTICSEARCH_DOCS, "actions-pagerduty.html"),
      slackAction: "".concat(ELASTICSEARCH_DOCS, "actions-slack.html"),
      ui: "".concat(KIBANA_DOCS, "watcher-ui.html")
    },
    ccs: {
      guide: "".concat(ELASTICSEARCH_DOCS, "modules-cross-cluster-search.html"),
      skippingDisconnectedClusters: "".concat(ELASTICSEARCH_DOCS, "modules-cross-cluster-search.html#skip-unavailable-clusters")
    },
    apis: {
      bulkIndexAlias: "".concat(ELASTICSEARCH_DOCS, "indices-aliases.html"),
      byteSizeUnits: "".concat(ELASTICSEARCH_DOCS, "api-conventions.html#byte-units"),
      createAutoFollowPattern: "".concat(ELASTICSEARCH_DOCS, "ccr-put-auto-follow-pattern.html"),
      createFollower: "".concat(ELASTICSEARCH_DOCS, "ccr-put-follow.html"),
      createIndex: "".concat(ELASTICSEARCH_DOCS, "indices-create-index.html"),
      createSnapshotLifecyclePolicy: "".concat(ELASTICSEARCH_DOCS, "slm-api-put-policy.html"),
      createRoleMapping: "".concat(ELASTICSEARCH_DOCS, "security-api-put-role-mapping.html"),
      createRoleMappingTemplates: "".concat(ELASTICSEARCH_DOCS, "security-api-put-role-mapping.html#_role_templates"),
      createRollupJobsRequest: "".concat(ELASTICSEARCH_DOCS, "rollup-put-job.html#rollup-put-job-api-request-body"),
      createApiKey: "".concat(ELASTICSEARCH_DOCS, "security-api-create-api-key.html"),
      createPipeline: "".concat(ELASTICSEARCH_DOCS, "put-pipeline-api.html"),
      createTransformRequest: "".concat(ELASTICSEARCH_DOCS, "put-transform.html#put-transform-request-body"),
      cronExpressions: "".concat(ELASTICSEARCH_DOCS, "cron-expressions.html"),
      executeWatchActionModes: "".concat(ELASTICSEARCH_DOCS, "watcher-api-execute-watch.html#watcher-api-execute-watch-action-mode"),
      indexExists: "".concat(ELASTICSEARCH_DOCS, "indices-exists.html"),
      multiSearch: "".concat(ELASTICSEARCH_DOCS, "search-multi-search.html"),
      openIndex: "".concat(ELASTICSEARCH_DOCS, "indices-open-close.html"),
      putComponentTemplate: "".concat(ELASTICSEARCH_DOCS, "indices-component-template.html"),
      painlessExecute: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/painless/").concat(DOC_LINK_VERSION, "/painless-execute-api.html"),
      painlessExecuteAPIContexts: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/painless/").concat(DOC_LINK_VERSION, "/painless-execute-api.html#_contexts"),
      putComponentTemplateMetadata: "".concat(ELASTICSEARCH_DOCS, "indices-component-template.html#component-templates-metadata"),
      putEnrichPolicy: "".concat(ELASTICSEARCH_DOCS, "put-enrich-policy-api.html"),
      putIndexTemplateV1: "".concat(ELASTICSEARCH_DOCS, "indices-templates-v1.html"),
      putSnapshotLifecyclePolicy: "".concat(ELASTICSEARCH_DOCS, "slm-api-put-policy.html"),
      putWatch: "".concat(ELASTICSEARCH_DOCS, "watcher-api-put-watch.html"),
      searchPreference: "".concat(ELASTICSEARCH_DOCS, "search-search.html#search-preference"),
      simulatePipeline: "".concat(ELASTICSEARCH_DOCS, "simulate-pipeline-api.html"),
      timeUnits: "".concat(ELASTICSEARCH_DOCS, "api-conventions.html#time-units"),
      unfreezeIndex: "".concat(ELASTICSEARCH_DOCS, "unfreeze-index-api.html"),
      updateTransform: "".concat(ELASTICSEARCH_DOCS, "update-transform.html")
    },
    plugins: {
      azureRepo: "".concat(ELASTICSEARCH_DOCS, "repository-azure.html"),
      gcsRepo: "".concat(ELASTICSEARCH_DOCS, "repository-gcs.html"),
      hdfsRepo: "".concat(PLUGIN_DOCS, "repository-hdfs.html"),
      ingestAttachment: "".concat(PLUGIN_DOCS, "ingest-attachment.html"),
      s3Repo: "".concat(ELASTICSEARCH_DOCS, "repository-s3.html"),
      snapshotRestoreRepos: "".concat(ELASTICSEARCH_DOCS, "snapshots-register-repository.html"),
      mapperSize: "".concat(PLUGIN_DOCS, "mapper-size-usage.html")
    },
    snapshotRestore: {
      guide: "".concat(ELASTICSEARCH_DOCS, "snapshot-restore.html"),
      changeIndexSettings: "".concat(ELASTICSEARCH_DOCS, "index-modules.html"),
      createSnapshot: "".concat(ELASTICSEARCH_DOCS, "snapshots-take-snapshot.html"),
      getSnapshot: "".concat(ELASTICSEARCH_DOCS, "get-snapshot-api.html"),
      registerSharedFileSystem: "".concat(ELASTICSEARCH_DOCS, "snapshots-filesystem-repository.html#filesystem-repository-settings"),
      registerSourceOnly: "".concat(ELASTICSEARCH_DOCS, "snapshots-source-only-repository.html#source-only-repository-settings"),
      registerUrl: "".concat(ELASTICSEARCH_DOCS, "snapshots-read-only-repository.html#read-only-url-repository-settings"),
      restoreSnapshot: "".concat(ELASTICSEARCH_DOCS, "snapshots-restore-snapshot.html"),
      restoreSnapshotApi: "".concat(ELASTICSEARCH_DOCS, "restore-snapshot-api.html#restore-snapshot-api-request-body"),
      searchableSnapshotSharedCache: "".concat(ELASTICSEARCH_DOCS, "searchable-snapshots.html#searchable-snapshots-shared-cache")
    },
    ingest: {
      append: "".concat(ELASTICSEARCH_DOCS, "append-processor.html"),
      bytes: "".concat(ELASTICSEARCH_DOCS, "bytes-processor.html"),
      circle: "".concat(ELASTICSEARCH_DOCS, "ingest-circle-processor.html"),
      convert: "".concat(ELASTICSEARCH_DOCS, "convert-processor.html"),
      csv: "".concat(ELASTICSEARCH_DOCS, "csv-processor.html"),
      date: "".concat(ELASTICSEARCH_DOCS, "date-processor.html"),
      dateIndexName: "".concat(ELASTICSEARCH_DOCS, "date-index-name-processor.html"),
      dissect: "".concat(ELASTICSEARCH_DOCS, "dissect-processor.html"),
      dissectKeyModifiers: "".concat(ELASTICSEARCH_DOCS, "dissect-processor.html#dissect-key-modifiers"),
      dotExpander: "".concat(ELASTICSEARCH_DOCS, "dot-expand-processor.html"),
      drop: "".concat(ELASTICSEARCH_DOCS, "drop-processor.html"),
      enrich: "".concat(ELASTICSEARCH_DOCS, "ingest-enriching-data.html"),
      fail: "".concat(ELASTICSEARCH_DOCS, "fail-processor.html"),
      foreach: "".concat(ELASTICSEARCH_DOCS, "foreach-processor.html"),
      geoIp: "".concat(ELASTICSEARCH_DOCS, "geoip-processor.html"),
      geoMatch: "".concat(ELASTICSEARCH_DOCS, "geo-match-enrich-policy-type.html"),
      grok: "".concat(ELASTICSEARCH_DOCS, "grok-processor.html"),
      gsub: "".concat(ELASTICSEARCH_DOCS, "gsub-processor.html"),
      htmlString: "".concat(ELASTICSEARCH_DOCS, "htmlstrip-processor.html"),
      inference: "".concat(ELASTICSEARCH_DOCS, "inference-processor.html"),
      inferenceClassification: "".concat(ELASTICSEARCH_DOCS, "inference-processor.html#inference-processor-classification-opt"),
      inferenceRegression: "".concat(ELASTICSEARCH_DOCS, "inference-processor.html#inference-processor-regression-opt"),
      join: "".concat(ELASTICSEARCH_DOCS, "join-processor.html"),
      json: "".concat(ELASTICSEARCH_DOCS, "json-processor.html"),
      kv: "".concat(ELASTICSEARCH_DOCS, "kv-processor.html"),
      lowercase: "".concat(ELASTICSEARCH_DOCS, "lowercase-processor.html"),
      pipeline: "".concat(ELASTICSEARCH_DOCS, "pipeline-processor.html"),
      pipelines: "".concat(ELASTICSEARCH_DOCS, "ingest.html"),
      csvPipelines: "".concat(ELASTIC_WEBSITE_URL, "guide/en/ecs/").concat(DOC_LINK_VERSION, "/ecs-converting.html"),
      pipelineFailure: "".concat(ELASTICSEARCH_DOCS, "ingest.html#handling-pipeline-failures"),
      processors: "".concat(ELASTICSEARCH_DOCS, "processors.html"),
      remove: "".concat(ELASTICSEARCH_DOCS, "remove-processor.html"),
      rename: "".concat(ELASTICSEARCH_DOCS, "rename-processor.html"),
      script: "".concat(ELASTICSEARCH_DOCS, "script-processor.html"),
      set: "".concat(ELASTICSEARCH_DOCS, "set-processor.html"),
      setSecurityUser: "".concat(ELASTICSEARCH_DOCS, "ingest-node-set-security-user-processor.html"),
      sort: "".concat(ELASTICSEARCH_DOCS, "sort-processor.html"),
      split: "".concat(ELASTICSEARCH_DOCS, "split-processor.html"),
      trim: "".concat(ELASTICSEARCH_DOCS, "trim-processor.html"),
      uppercase: "".concat(ELASTICSEARCH_DOCS, "uppercase-processor.html"),
      uriParts: "".concat(ELASTICSEARCH_DOCS, "uri-parts-processor.html"),
      urlDecode: "".concat(ELASTICSEARCH_DOCS, "urldecode-processor.html"),
      userAgent: "".concat(ELASTICSEARCH_DOCS, "user-agent-processor.html")
    },
    fleet: {
      guide: "".concat(FLEET_DOCS, "index.html"),
      fleetServer: "".concat(FLEET_DOCS, "fleet-server.html"),
      fleetServerAddFleetServer: "".concat(FLEET_DOCS, "add-a-fleet-server.html"),
      settings: "".concat(FLEET_DOCS, "fleet-settings.html"),
      settingsFleetServerHostSettings: "".concat(FLEET_DOCS, "fleet-settings.html#fleet-server-hosts-setting"),
      settingsFleetServerProxySettings: "".concat(KIBANA_DOCS, "fleet-settings-kb.html#fleet-data-visualizer-settings"),
      troubleshooting: "".concat(FLEET_DOCS, "fleet-troubleshooting.html"),
      elasticAgent: "".concat(FLEET_DOCS, "elastic-agent-installation.html"),
      beatsAgentComparison: "".concat(FLEET_DOCS, "beats-agent-comparison.html"),
      datastreams: "".concat(FLEET_DOCS, "data-streams.html"),
      datastreamsILM: "".concat(FLEET_DOCS, "data-streams.html#data-streams-ilm"),
      datastreamsNamingScheme: "".concat(FLEET_DOCS, "data-streams.html#data-streams-naming-scheme"),
      installElasticAgent: "".concat(FLEET_DOCS, "install-fleet-managed-elastic-agent.html"),
      installElasticAgentStandalone: "".concat(FLEET_DOCS, "install-standalone-elastic-agent.html"),
      upgradeElasticAgent: "".concat(FLEET_DOCS, "upgrade-elastic-agent.html"),
      learnMoreBlog: "".concat(ELASTIC_WEBSITE_URL, "blog/elastic-agent-and-fleet-make-it-easier-to-integrate-your-systems-with-elastic"),
      apiKeysLearnMore: "".concat(KIBANA_DOCS, "api-keys.html"),
      onPremRegistry: "".concat(FLEET_DOCS, "air-gapped.html"),
      packageSignatures: "".concat(FLEET_DOCS, "package-signatures.html"),
      secureLogstash: "".concat(FLEET_DOCS, "secure-logstash-connections.html"),
      agentPolicy: "".concat(FLEET_DOCS, "agent-policy.html")
    },
    ecs: {
      guide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/ecs/current/index.html")
    },
    clients: {
      /** Changes to these URLs must also be synched in src/plugins/custom_integrations/server/language_clients/index.ts */
      guide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/index.html"),
      goIndex: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/go-api/").concat(DOC_LINK_VERSION, "/index.html"),
      goOverview: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/go-api/").concat(DOC_LINK_VERSION, "/overview.html"),
      javaBasicAuthentication: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/java-api-client/").concat(DOC_LINK_VERSION, "/_basic_authentication.html"),
      javaIndex: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/java-api-client/").concat(DOC_LINK_VERSION, "/index.html"),
      javaInstallation: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/java-api-client/").concat(DOC_LINK_VERSION, "/installation.html"),
      javaIntroduction: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/java-api-client/").concat(DOC_LINK_VERSION, "/introduction.html"),
      javaRestLow: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/java-api-client/").concat(DOC_LINK_VERSION, "/java-rest-low.html"),
      jsClientConnecting: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/javascript-api/").concat(DOC_LINK_VERSION, "/client-connecting.html"),
      jsIntro: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/javascript-api/").concat(DOC_LINK_VERSION, "/introduction.html"),
      netGuide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/net-api/").concat(DOC_LINK_VERSION, "/index.html"),
      netIntroduction: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/net-api/").concat(DOC_LINK_VERSION, "/introduction.html"),
      netNest: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/net-api/").concat(DOC_LINK_VERSION, "/nest.html"),
      netSingleNode: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/net-api/").concat(DOC_LINK_VERSION, "/connecting.html#single-node"),
      perlGuide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/perl-api/").concat(DOC_LINK_VERSION, "/index.html"),
      phpConnecting: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/php-api/").concat(DOC_LINK_VERSION, "/connecting.html"),
      phpInstallation: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/php-api/").concat(DOC_LINK_VERSION, "/installation.html"),
      phpGuide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/php-api/").concat(DOC_LINK_VERSION, "/index.html"),
      phpOverview: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/php-api/").concat(DOC_LINK_VERSION, "/overview.html"),
      pythonAuthentication: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/python-api/").concat(DOC_LINK_VERSION, "/connecting.html#authentication"),
      pythonGuide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/python-api/").concat(DOC_LINK_VERSION, "/index.html"),
      pythonOverview: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/python-api/").concat(DOC_LINK_VERSION, "/overview.html"),
      rubyAuthentication: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/ruby-api/").concat(DOC_LINK_VERSION, "/connecting.html#client-auth"),
      rubyOverview: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/ruby-api/").concat(DOC_LINK_VERSION, "/ruby_client.html"),
      rustGuide: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/rust-api/").concat(DOC_LINK_VERSION, "/index.html"),
      rustOverview: "".concat(ELASTIC_WEBSITE_URL, "guide/en/elasticsearch/client/rust-api/").concat(DOC_LINK_VERSION, "/overview.html")
    },
    endpoints: {
      troubleshooting: "".concat(SECURITY_SOLUTION_DOCS, "ts-management.html#ts-endpoints")
    },
    legal: {
      privacyStatement: "".concat(ELASTIC_WEBSITE_URL, "legal/privacy-statement")
    },
    kibanaUpgradeSavedObjects: {
      resolveMigrationFailures: "".concat(KIBANA_DOCS, "resolve-migrations-failures.html"),
      repeatedTimeoutRequests: "".concat(KIBANA_DOCS, "resolve-migrations-failures.html#_repeated_time_out_requests_that_eventually_fail"),
      routingAllocationDisabled: "".concat(KIBANA_DOCS, "resolve-migrations-failures.html#routing-allocation-disabled"),
      clusterShardLimitExceeded: "".concat(KIBANA_DOCS, "resolve-migrations-failures.html#cluster-shard-limit-exceeded")
    },
    searchUI: {
      appSearch: "".concat(SEARCH_UI_DOCS, "tutorials/app-search"),
      elasticsearch: "".concat(SEARCH_UI_DOCS, "tutorials/elasticsearch")
    }
  });
};