import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { getFilterField, cleanFilter } from '../filters';
import { getDataViewFieldSubtypeNested } from '../utils';
/** @internal */

export var handleNestedFilter = function handleNestedFilter(filter, indexPattern) {
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (!indexPattern) return filter;
  var fieldName = getFilterField(filter);

  if (!fieldName) {
    return filter;
  }

  var field = indexPattern.fields.find(function (indexPatternField) {
    return indexPatternField.name === fieldName;
  });
  var subTypeNested = field && getDataViewFieldSubtypeNested(field);

  if (!subTypeNested) {
    return filter;
  }

  var query = cleanFilter(filter);
  return {
    meta: filter.meta,
    query: {
      nested: _objectSpread({
        path: subTypeNested.nested.path,
        query: query.query || query
      }, typeof config.ignoreUnmapped === 'boolean' && {
        ignore_unmapped: config.ignoreUnmapped
      })
    }
  };
};