/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { FILTERS } from './types';
/**
 * @internal used only by the filter bar to create filter pills.
 */

export function getFilterParams(filter) {
  switch (filter.meta.type) {
    case FILTERS.PHRASE:
      return filter.meta.params.query;

    case FILTERS.PHRASES:
      return filter.meta.params;

    case FILTERS.RANGE:
      var _meta$params = filter.meta.params,
          gte = _meta$params.gte,
          gt = _meta$params.gt,
          lte = _meta$params.lte,
          lt = _meta$params.lt;
      return {
        from: gte !== null && gte !== void 0 ? gte : gt,
        to: lt !== null && lt !== void 0 ? lt : lte
      };
  }
}