/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { each, union } from 'lodash';
import { dedupFilters } from './dedup_filters';
/**
 * Remove duplicate filters from an array of filters
 *
 * @param {array} filters The filters to remove duplicates from
 * @param {object} comparatorOptions - Parameters to use for comparison
 * @returns {object} The original filters array with duplicates removed
 * @public
 */

export var uniqFilters = function uniqFilters(filters) {
  var comparatorOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var results = [];
  each(filters, function (filter) {
    results = union(results, dedupFilters(results, [filter], comparatorOptions));
  });
  return results;
};