import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { nodeTypes } from '../node_types';
import { KQLSyntaxError } from '../kuery_syntax_error';
import { parse as parseKuery } from '../grammar';

var fromExpression = function fromExpression(expression) {
  var parseOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var parse = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : parseKuery;

  if (typeof expression === 'undefined') {
    throw new Error('expression must be a string, got undefined instead');
  }

  return parse(expression, _objectSpread(_objectSpread({}, parseOptions), {}, {
    helpers: {
      nodeTypes: nodeTypes
    }
  }));
};

export var fromLiteralExpression = function fromLiteralExpression(expression) {
  var parseOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return fromExpression(expression, _objectSpread(_objectSpread({}, parseOptions), {}, {
    startRule: 'Literal'
  }), parseKuery);
};
export var fromKueryExpression = function fromKueryExpression(expression) {
  var parseOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  try {
    return fromExpression(expression, parseOptions, parseKuery);
  } catch (error) {
    if (error.name === 'SyntaxError') {
      throw new KQLSyntaxError(error, expression);
    } else {
      throw error;
    }
  }
};
/**
 * @params {String} indexPattern
 * @params {Object} config - contains the dateFormatTZ
 *
 * IndexPattern isn't required, but if you pass one in, we can be more intelligent
 * about how we craft the queries (e.g. scripted fields)
 *
 */

export var toElasticsearchQuery = function toElasticsearchQuery(node, indexPattern) {
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var context = arguments.length > 3 ? arguments[3] : undefined;

  if (!node || !node.type || !nodeTypes[node.type]) {
    return toElasticsearchQuery(nodeTypes["function"].buildNode('and', []), indexPattern);
  } // TODO: the return type of this function might be incorrect and it works only because of this casting


  var nodeType = nodeTypes[node.type];
  return nodeType.toElasticsearchQuery(node, indexPattern, config, context);
};