/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { createKbnFieldTypes, kbnFieldTypeUnknown } from './kbn_field_types_factory';
import { KBN_FIELD_TYPES } from './types';
/** @private */

var registeredKbnTypes = createKbnFieldTypes();
/**
 *  Get a type object by name
 *
 *  @param  {string} typeName
 *  @return {KbnFieldType}
 */

export var getKbnFieldType = function getKbnFieldType(typeName) {
  return registeredKbnTypes.find(function (t) {
    return t.name === typeName;
  }) || kbnFieldTypeUnknown;
};
/**
 *  Get the esTypes known by all kbnFieldTypes
 *
 *  @return {Array<string>}
 */

export var getKbnTypeNames = function getKbnTypeNames() {
  return registeredKbnTypes.filter(function (type) {
    return type.name;
  }).map(function (type) {
    return type.name;
  });
};
/**
 *  Get the KbnFieldType name for an esType string
 *
 *  @param {string} esType
 *  @return {string}
 */

export var castEsToKbnFieldTypeName = function castEsToKbnFieldTypeName(esType) {
  var type = registeredKbnTypes.find(function (t) {
    return t.esTypes.includes(esType);
  });
  return type && type.name ? type.name : KBN_FIELD_TYPES.UNKNOWN;
};
/**
 *  Get filterable KbnFieldTypes
 *
 *  @return {Array<string>}
 */

export var getFilterableKbnTypeNames = function getFilterableKbnTypeNames() {
  return registeredKbnTypes.filter(function (type) {
    return type.filterable;
  }).map(function (type) {
    return type.name;
  });
};