/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { formats, addTranslation, getTranslation, setLocale, getLocale, setDefaultLocale, getDefaultLocale, setFormats, getFormats, getRegisteredLocales, translate, init, load, isPseudoLocale, translateUsingPseudoLocale } from './src/core';
import { registerTranslationFile, registerTranslationFiles, getTranslationsByLocale, getAllTranslations, getAllTranslationsFromPaths, getRegisteredLocales as getRegisteredLocalesForLoader } from './src/loader';
var i18n = {
  formats: formats,
  addTranslation: addTranslation,
  getTranslation: getTranslation,
  setLocale: setLocale,
  getLocale: getLocale,
  setDefaultLocale: setDefaultLocale,
  getDefaultLocale: getDefaultLocale,
  setFormats: setFormats,
  getFormats: getFormats,
  getRegisteredLocales: getRegisteredLocales,
  translate: translate,
  init: init,
  load: load,
  isPseudoLocale: isPseudoLocale,
  translateUsingPseudoLocale: translateUsingPseudoLocale
};
var i18nLoader = {
  registerTranslationFile: registerTranslationFile,
  registerTranslationFiles: registerTranslationFiles,
  getTranslationsByLocale: getTranslationsByLocale,
  getAllTranslations: getAllTranslations,
  getAllTranslationsFromPaths: getAllTranslationsFromPaths,
  getRegisteredLocales: getRegisteredLocalesForLoader
};
export { i18n, i18nLoader };