import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { mapValues, includes } from 'lodash';
import { Arg } from './arg';
export function Fn(config) {
  var _this = this;

  // Required
  this.name = config.name; // Name of function
  // Return type of function.
  // This SHOULD be supplied. We use it for UI and autocomplete hinting,
  // We may also use it for optimizations in the future.

  this.type = config.type;
  this.aliases = config.aliases || []; // Function to run function (context, args)

  this.fn = function () {
    return Promise.resolve(config.fn.apply(config, arguments));
  }; // Optional


  this.help = config.help || ''; // A short help text

  this.args = mapValues(config.args || {}, function (arg, name) {
    return new Arg(_objectSpread({
      name: name
    }, arg));
  });
  this.context = config.context || {};

  this.accepts = function (type) {
    if (!_this.context.types) return true; // If you don't tell us about context, we'll assume you don't care what you get

    return includes(_this.context.types, type); // Otherwise, check it
  };
}