/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var parseableTags = ['StringType', 'NumberType', 'BooleanType', 'ArrayType', 'DictionaryType', 'InterfaceType', 'PartialType', 'UnionType', 'IntersectionType', 'MergeType'];
export var isParsableType = function isParsableType(type) {
  return '_tag' in type && parseableTags.includes(type._tag);
};