/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var KIBANA_NAMESPACE = 'kibana';
var ALERT_NAMESPACE = "".concat(KIBANA_NAMESPACE, ".alert");
var ALERT_RULE_NAMESPACE = "".concat(ALERT_NAMESPACE, ".rule");
var ECS_VERSION = 'ecs.version';
var EVENT_ACTION = 'event.action';
var EVENT_KIND = 'event.kind';
var EVENT_MODULE = 'event.module';
var SPACE_IDS = "".concat(KIBANA_NAMESPACE, ".space_ids");
var TAGS = 'tags';
var TIMESTAMP = '@timestamp';
var VERSION = "".concat(KIBANA_NAMESPACE, ".version"); // Fields pertaining to the alert

var ALERT_ACTION_GROUP = "".concat(ALERT_NAMESPACE, ".action_group");
var ALERT_BUILDING_BLOCK_TYPE = "".concat(ALERT_NAMESPACE, ".building_block_type");
var ALERT_DURATION = "".concat(ALERT_NAMESPACE, ".duration.us");
var ALERT_END = "".concat(ALERT_NAMESPACE, ".end");
var ALERT_EVALUATION_THRESHOLD = "".concat(ALERT_NAMESPACE, ".evaluation.threshold");
var ALERT_EVALUATION_VALUE = "".concat(ALERT_NAMESPACE, ".evaluation.value");
var ALERT_INSTANCE_ID = "".concat(ALERT_NAMESPACE, ".instance.id");
var ALERT_REASON = "".concat(ALERT_NAMESPACE, ".reason");
var ALERT_RISK_SCORE = "".concat(ALERT_NAMESPACE, ".risk_score");
var ALERT_SEVERITY = "".concat(ALERT_NAMESPACE, ".severity");
var ALERT_START = "".concat(ALERT_NAMESPACE, ".start");
var ALERT_STATUS = "".concat(ALERT_NAMESPACE, ".status");
var ALERT_SYSTEM_STATUS = "".concat(ALERT_NAMESPACE, ".system_status");
var ALERT_UUID = "".concat(ALERT_NAMESPACE, ".uuid");
var ALERT_WORKFLOW_REASON = "".concat(ALERT_NAMESPACE, ".workflow_reason");
var ALERT_WORKFLOW_STATUS = "".concat(ALERT_NAMESPACE, ".workflow_status");
var ALERT_WORKFLOW_USER = "".concat(ALERT_NAMESPACE, ".workflow_user"); // Fields pertaining to the rule associated with the alert

var ALERT_RULE_AUTHOR = "".concat(ALERT_RULE_NAMESPACE, ".author");
var ALERT_RULE_CREATED_AT = "".concat(ALERT_RULE_NAMESPACE, ".created_at");
var ALERT_RULE_CREATED_BY = "".concat(ALERT_RULE_NAMESPACE, ".created_by");
var ALERT_RULE_DESCRIPTION = "".concat(ALERT_RULE_NAMESPACE, ".description");
var ALERT_RULE_ENABLED = "".concat(ALERT_RULE_NAMESPACE, ".enabled");
var ALERT_RULE_EXCEPTIONS_LIST = "".concat(ALERT_RULE_NAMESPACE, ".exceptions_list");
var ALERT_RULE_EXECUTION_UUID = "".concat(ALERT_RULE_NAMESPACE, ".execution.uuid");
var ALERT_RULE_FROM = "".concat(ALERT_RULE_NAMESPACE, ".from");
var ALERT_RULE_INTERVAL = "".concat(ALERT_RULE_NAMESPACE, ".interval");
var ALERT_RULE_LICENSE = "".concat(ALERT_RULE_NAMESPACE, ".license");
var ALERT_RULE_CATEGORY = "".concat(ALERT_RULE_NAMESPACE, ".category");
var ALERT_RULE_NAME = "".concat(ALERT_RULE_NAMESPACE, ".name");
var ALERT_RULE_NAMESPACE_FIELD = "".concat(ALERT_RULE_NAMESPACE, ".namespace");
var ALERT_RULE_NOTE = "".concat(ALERT_RULE_NAMESPACE, ".note");
var ALERT_RULE_PARAMETERS = "".concat(ALERT_RULE_NAMESPACE, ".parameters");
var ALERT_RULE_REFERENCES = "".concat(ALERT_RULE_NAMESPACE, ".references");
var ALERT_RULE_RULE_ID = "".concat(ALERT_RULE_NAMESPACE, ".rule_id");
var ALERT_RULE_RULE_NAME_OVERRIDE = "".concat(ALERT_RULE_NAMESPACE, ".rule_name_override");
var ALERT_RULE_TAGS = "".concat(ALERT_RULE_NAMESPACE, ".tags");
var ALERT_RULE_TO = "".concat(ALERT_RULE_NAMESPACE, ".to");
var ALERT_RULE_TYPE = "".concat(ALERT_RULE_NAMESPACE, ".type");
var ALERT_RULE_TYPE_ID = "".concat(ALERT_RULE_NAMESPACE, ".rule_type_id");
var ALERT_RULE_UPDATED_AT = "".concat(ALERT_RULE_NAMESPACE, ".updated_at");
var ALERT_RULE_UPDATED_BY = "".concat(ALERT_RULE_NAMESPACE, ".updated_by");
var ALERT_RULE_VERSION = "".concat(ALERT_RULE_NAMESPACE, ".version"); // the feature instantiating a rule type.
// Rule created in stack --> alerts
// Rule created in siem --> siem

var ALERT_RULE_CONSUMER = "".concat(ALERT_RULE_NAMESPACE, ".consumer"); // the plugin that registered the rule type.
// Rule type apm.error_rate --> apm
// Rule type siem.signals --> siem

var ALERT_RULE_PRODUCER = "".concat(ALERT_RULE_NAMESPACE, ".producer");
var ALERT_RULE_UUID = "".concat(ALERT_RULE_NAMESPACE, ".uuid");
var namespaces = {
  KIBANA_NAMESPACE: KIBANA_NAMESPACE,
  ALERT_NAMESPACE: ALERT_NAMESPACE,
  ALERT_RULE_NAMESPACE: ALERT_RULE_NAMESPACE
};
var fields = {
  ECS_VERSION: ECS_VERSION,
  EVENT_KIND: EVENT_KIND,
  EVENT_ACTION: EVENT_ACTION,
  EVENT_MODULE: EVENT_MODULE,
  TAGS: TAGS,
  TIMESTAMP: TIMESTAMP,
  ALERT_ACTION_GROUP: ALERT_ACTION_GROUP,
  ALERT_BUILDING_BLOCK_TYPE: ALERT_BUILDING_BLOCK_TYPE,
  ALERT_DURATION: ALERT_DURATION,
  ALERT_END: ALERT_END,
  ALERT_EVALUATION_THRESHOLD: ALERT_EVALUATION_THRESHOLD,
  ALERT_EVALUATION_VALUE: ALERT_EVALUATION_VALUE,
  ALERT_INSTANCE_ID: ALERT_INSTANCE_ID,
  ALERT_RULE_CONSUMER: ALERT_RULE_CONSUMER,
  ALERT_RULE_PRODUCER: ALERT_RULE_PRODUCER,
  ALERT_REASON: ALERT_REASON,
  ALERT_RISK_SCORE: ALERT_RISK_SCORE,
  ALERT_RULE_AUTHOR: ALERT_RULE_AUTHOR,
  ALERT_RULE_CREATED_AT: ALERT_RULE_CREATED_AT,
  ALERT_RULE_CREATED_BY: ALERT_RULE_CREATED_BY,
  ALERT_RULE_DESCRIPTION: ALERT_RULE_DESCRIPTION,
  ALERT_RULE_ENABLED: ALERT_RULE_ENABLED,
  ALERT_RULE_EXCEPTIONS_LIST: ALERT_RULE_EXCEPTIONS_LIST,
  ALERT_RULE_EXECUTION_UUID: ALERT_RULE_EXECUTION_UUID,
  ALERT_RULE_FROM: ALERT_RULE_FROM,
  ALERT_RULE_INTERVAL: ALERT_RULE_INTERVAL,
  ALERT_RULE_LICENSE: ALERT_RULE_LICENSE,
  ALERT_RULE_NAME: ALERT_RULE_NAME,
  ALERT_RULE_NAMESPACE_FIELD: ALERT_RULE_NAMESPACE_FIELD,
  ALERT_RULE_NOTE: ALERT_RULE_NOTE,
  ALERT_RULE_PARAMETERS: ALERT_RULE_PARAMETERS,
  ALERT_RULE_REFERENCES: ALERT_RULE_REFERENCES,
  ALERT_RULE_RULE_ID: ALERT_RULE_RULE_ID,
  ALERT_RULE_RULE_NAME_OVERRIDE: ALERT_RULE_RULE_NAME_OVERRIDE,
  ALERT_RULE_TAGS: ALERT_RULE_TAGS,
  ALERT_RULE_TO: ALERT_RULE_TO,
  ALERT_RULE_TYPE: ALERT_RULE_TYPE,
  ALERT_RULE_TYPE_ID: ALERT_RULE_TYPE_ID,
  ALERT_RULE_UPDATED_AT: ALERT_RULE_UPDATED_AT,
  ALERT_RULE_UPDATED_BY: ALERT_RULE_UPDATED_BY,
  ALERT_RULE_VERSION: ALERT_RULE_VERSION,
  ALERT_START: ALERT_START,
  ALERT_SEVERITY: ALERT_SEVERITY,
  ALERT_STATUS: ALERT_STATUS,
  ALERT_SYSTEM_STATUS: ALERT_SYSTEM_STATUS,
  ALERT_UUID: ALERT_UUID,
  ALERT_WORKFLOW_REASON: ALERT_WORKFLOW_REASON,
  ALERT_WORKFLOW_STATUS: ALERT_WORKFLOW_STATUS,
  ALERT_WORKFLOW_USER: ALERT_WORKFLOW_USER,
  ALERT_RULE_UUID: ALERT_RULE_UUID,
  ALERT_RULE_CATEGORY: ALERT_RULE_CATEGORY,
  SPACE_IDS: SPACE_IDS,
  VERSION: VERSION
};
export { ALERT_ACTION_GROUP, ALERT_BUILDING_BLOCK_TYPE, ALERT_DURATION, ALERT_END, ALERT_EVALUATION_THRESHOLD, ALERT_EVALUATION_VALUE, ALERT_INSTANCE_ID, ALERT_NAMESPACE, ALERT_RULE_NAMESPACE, ALERT_RULE_CONSUMER, ALERT_RULE_PRODUCER, ALERT_REASON, ALERT_RISK_SCORE, ALERT_STATUS, ALERT_WORKFLOW_REASON, ALERT_WORKFLOW_STATUS, ALERT_WORKFLOW_USER, ALERT_RULE_AUTHOR, ALERT_RULE_CREATED_AT, ALERT_RULE_CREATED_BY, ALERT_RULE_DESCRIPTION, ALERT_RULE_ENABLED, ALERT_RULE_EXCEPTIONS_LIST, ALERT_RULE_EXECUTION_UUID, ALERT_RULE_FROM, ALERT_RULE_INTERVAL, ALERT_RULE_LICENSE, ALERT_RULE_NAME, ALERT_RULE_NAMESPACE_FIELD, ALERT_RULE_NOTE, ALERT_RULE_PARAMETERS, ALERT_RULE_REFERENCES, ALERT_RULE_RULE_ID, ALERT_RULE_RULE_NAME_OVERRIDE, ALERT_RULE_TAGS, ALERT_RULE_TO, ALERT_RULE_TYPE, ALERT_RULE_TYPE_ID, ALERT_RULE_UPDATED_AT, ALERT_RULE_UPDATED_BY, ALERT_RULE_VERSION, ALERT_SEVERITY, ALERT_START, ALERT_SYSTEM_STATUS, ALERT_UUID, ECS_VERSION, EVENT_ACTION, EVENT_KIND, EVENT_MODULE, KIBANA_NAMESPACE, ALERT_RULE_UUID, ALERT_RULE_CATEGORY, TAGS, TIMESTAMP, SPACE_IDS, VERSION };