/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { language } from '../language';
/**
 * Types the DefaultLanguageString as:
 *   - If null or undefined, then a default of the string "kuery" will be used
 */

export var DefaultLanguageString = new t.Type('DefaultLanguageString', t.string.is, function (input, context) {
  return input == null ? t.success('kuery') : language.validate(input, context);
}, t.identity);