/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { endpointEntryMatch } from '../entry_match';
import { endpointEntryMatchAny } from '../entry_match_any';
export var endpointNestedEntriesArray = t.array(t.union([endpointEntryMatch, endpointEntryMatchAny]));

/**
 * Types the nonEmptyNestedEntriesArray as:
 *   - An array of entries of length 1 or greater
 *
 */
export var nonEmptyEndpointNestedEntriesArray = new t.Type('NonEmptyEndpointNestedEntriesArray', function (u) {
  return endpointNestedEntriesArray.is(u) && u.length > 0;
}, function (input, context) {
  if (Array.isArray(input) && input.length === 0) {
    return t.failure(input, context);
  } else {
    return endpointNestedEntriesArray.validate(input, context);
  }
}, t.identity);