"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultCsvArray = void 0;

var t = _interopRequireWildcard(require("io-ts"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Creates a schema of an array that works in the following way:
 *   - If input is a CSV string, it will be parsed to an array which will be validated.
 *   - If input is an array, each item is validated to match `itemSchema`.
 *   - If input is a single string, it is validated to match `itemSchema`.
 *   - If input is not specified, the result will be set to [] (empty array):
 *     - null, undefined, empty string, empty array
 *
 * In all cases when an input is valid, the resulting decoded value will be an array,
 * either an empty one or containing valid items.
 *
 * @param itemSchema Schema of the array's items.
 * @param name (Optional) Name of the resulting schema.
 */
const defaultCsvArray = (itemSchema, name) => {
  return new t.Type(name !== null && name !== void 0 ? name : `DefaultCsvArray<${itemSchema.name}>`, t.array(itemSchema).is, (input, context) => {
    if (input == null) {
      return t.success([]);
    } else if (typeof input === 'string') {
      if (input === '') {
        return t.success([]);
      } else {
        return t.array(itemSchema).validate(input.split(','), context);
      }
    } else {
      return t.array(itemSchema).validate(input, context);
    }
  }, t.identity);
};

exports.defaultCsvArray = defaultCsvArray;