/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';

/**
 * Types the EmptyStringArray as:
 *   - A value that can be undefined, or null (which will be turned into an empty array)
 *   - A comma separated string that can turn into an array by splitting on it
 *   - Example input converted to output: undefined -> []
 *   - Example input converted to output: null -> []
 *   - Example input converted to output: "a,b,c" -> ["a", "b", "c"]
 */
export var EmptyStringArray = new t.Type('EmptyStringArray', t.array(t.string).is, function (input, context) {
  if (input == null) {
    return t.success([]);
  } else if (typeof input === 'string' && input.trim() !== '') {
    var arrayValues = input.trim().split(',').map(function (value) {
      return value.trim();
    });
    var emptyValueFound = arrayValues.some(function (value) {
      return value === '';
    });

    if (emptyValueFound) {
      return t.failure(input, context);
    } else {
      return t.success(arrayValues);
    }
  } else {
    return t.failure(input, context);
  }
}, String);